% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructAdjacency.R
\name{computeParentAdjacency}
\alias{computeParentAdjacency}
\title{Compute Parent Adjacency Matrix with Multiple Approaches}
\usage{
computeParentAdjacency(
  ped,
  component,
  adjacency_method = "direct",
  saveable,
  resume,
  save_path,
  verbose = FALSE,
  lastComputed = 0,
  checkpoint_files,
  update_rate,
  parList,
  lens,
  save_rate_parlist,
  adjBeta_method = NULL,
  config,
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{component}{character.  Which component of the pedigree to return.  See Details.}

\item{adjacency_method}{character. The method to use for computing the adjacency matrix.  Options are "loop", "indexed", direct or beta}

\item{saveable}{logical. If TRUE, save the intermediate results to disk}

\item{resume}{logical. If TRUE, resume from a checkpoint}

\item{save_path}{character. The path to save the checkpoint files}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{lastComputed}{the last computed index}

\item{checkpoint_files}{a list of checkpoint files}

\item{update_rate}{the rate at which to update the progress}

\item{parList}{a list of parent-child relationships}

\item{lens}{a vector of the lengths of the parent-child relationships}

\item{save_rate_parlist}{numeric. The rate at which to save the intermediate results by parent list. If NULL, defaults to save_rate*1000}

\item{adjBeta_method}{numeric The method to use for computing the building the adjacency_method matrix when using the "beta" build}

\item{config}{a configuration list that passes parameters to the function}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Compute Parent Adjacency Matrix with Multiple Approaches
}
\details{
The algorithms and methodologies used in this function are further discussed and exemplified in the vignette titled "examplePedigreeFunctions". For more advanced scenarios and detailed explanations, consult this vignette.
}
