% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_intersect_species}
\alias{BIEN_ranges_intersect_species}
\title{Download range maps that intersect the range of a given species.}
\usage{
BIEN_ranges_intersect_species(species, directory = NULL,
  species.names.only = FALSE, include.focal = TRUE,
  return.species.list = TRUE, include.gid = FALSE, print.query = FALSE,
  ...)
}
\arguments{
\item{species}{Focal species (or a vector of species) for which to extract intersecting ranges.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species.names.only}{Get a list of the species with ranges overlapping the focal species' range without downloading range maps. Default is FALSE.}

\item{include.focal}{Should the focal species be returned as well? Default is TRUE.}

\item{return.species.list}{Should a species list be returned?  Only meaningful when maps are being downloaded.}

\item{include.gid}{Should the filenames returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species. Default is FALSE.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Range maps for all available species that intersect the range of the focal species.
}
\description{
BIEN_ranges_intersect_species extracts range maps for a specified bounding box.
}
\examples{
\dontrun{
testwd<-"C:/wherever/you/want/files/saved/" #Set a working directory
BIEN_ranges_intersect_species(species = "Carnegiea_gigantea",
directory = testwd,include.focal = TRUE)
species_vector<-c("Carnegiea_gigantea","Echinocereus coccineus")
BIEN_ranges_intersect_species(species = speciesvector,species.names.only = TRUE)}
}
\author{
Daniel Guaderrama
}
\seealso{
Other range functions: \code{\link{BIEN_ranges_box}},
  \code{\link{BIEN_ranges_genus}},
  \code{\link{BIEN_ranges_load_species}},
  \code{\link{BIEN_ranges_shapefile}},
  \code{\link{BIEN_ranges_species}}
}

