% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_state}
\alias{BIEN_list_state}
\title{Extract a species list by state/province}
\usage{
BIEN_list_state(country, state, cultivated = FALSE, only.new.world = TRUE,
  ...)
}
\arguments{
\item{country}{A single country or a vector of countries equal in length to the vector of states/provinces.}

\item{state}{A single state/province, or a vector of states/provinces.}

\item{cultivated}{Return cultivated records as well?  Default is FALSE.}

\item{only.new.world}{Return only records from the New World?  Default is true}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing species list(s) for the specified states/provinces.
}
\description{
BIEN_list_state produces a list of all species with geovalidated occurrences falling within specified state(s) or province(s).
}
\examples{
\dontrun{
BIEN_list_state("United States","Michigan")
state_vector<-c("Michigan","Arizona")
BIEN_list_state(country="United States", state= state_vector)}
}
\seealso{
Other list functions: \code{\link{BIEN_list_all}},
  \code{\link{BIEN_list_country}},
  \code{\link{BIEN_list_county}},
  \code{\link{BIEN_list_shapefile}}
}
