% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_list_county}
\alias{BIEN_list_county}
\title{Extract a species list by county.}
\usage{
BIEN_list_county(
  country = NULL,
  state = NULL,
  county = NULL,
  country.code = NULL,
  state.code = NULL,
  county.code = NULL,
  cultivated = FALSE,
  new.world = NULL,
  ...
)
}
\arguments{
\item{country}{A single country or vector of countries}

\item{state}{A state or vector of states (or other primary political divisions, e.g. provinces).}

\item{county}{A single county (or other secondary administrative boundary)or vector of counties.}

\item{country.code}{A single country (or other primary administrative boundary) code or a vector of country codes equal in length to the vector of states/province codes.}

\item{state.code}{A single state/province code, or a vector of states/province codes.}

\item{county.code}{A single county (or other secondary administrative boundary) code or a vector of county codes equal in length to the vectors of states/province codes and country codes.}

\item{cultivated}{Return information on cultivation status?  Default is FALSE.}

\item{new.world}{NULL (The default) returns global records, TRUE returns only New World, and FALSE only Old World.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing species list(s) for the specified states/provinces.
}
\description{
BIEN_list_county produces a list of all species with geovalidated occurrences falling within specified county or counties.
}
\note{
Political division (or political division code) spelling needs to be exact and case-sensitive, see \code{\link{BIEN_metadata_list_political_names}} for a list of political divisions and associated codes.

We recommend using country, state, and county rather than codes, since county names have not been fully standardized.

This function requires you supply either 1) a single state and country with one or more counties, or 2) vectors of equal length for each political level.
}
\examples{
\dontrun{
BIEN_list_county("United States", "Michigan", "Kent")
BIEN_list_county(country = "United States", state = "Michigan", county = "Kent")
county_vector<-c("Kent","Kalamazoo")
BIEN_list_county(country = "United States", state = "Michigan", county = county_vector)}
}
\seealso{
Other list functions: 
\code{\link{BIEN_list_all}()},
\code{\link{BIEN_list_country}()},
\code{\link{BIEN_list_sf}()},
\code{\link{BIEN_list_state}()}
}
\concept{list functions}
