% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterVCF.R
\name{filterVCF}
\alias{filterVCF}
\title{Filter a VCF file}
\usage{
filterVCF(
  vcf.file,
  filter.OD = NULL,
  filter.BIAS.min = NULL,
  filter.BIAS.max = NULL,
  filter.DP = NULL,
  filter.MPP = NULL,
  filter.PMC = NULL,
  filter.MAF = NULL,
  filter.SAMPLE.miss = NULL,
  filter.SNP.miss = NULL,
  ploidy,
  output.file = NULL
)
}
\arguments{
\item{vcf.file}{vcfR object or path to VCF file. Can be unzipped (.vcf) or gzipped (.vcf.gz).}

\item{filter.OD}{Updog filter}

\item{filter.BIAS.min}{Updog filter (requires a value for both BIAS.min and BIAS.max)}

\item{filter.BIAS.max}{Updog filter (requires a value for both BIAS.min and BIAS.max)}

\item{filter.DP}{Total read depth at each SNP filter}

\item{filter.MPP}{Updog filter}

\item{filter.PMC}{Updog filter}

\item{filter.MAF}{Minor allele frequency filter}

\item{filter.SAMPLE.miss}{Sample missing data filter}

\item{filter.SNP.miss}{SNP missing data filter}

\item{ploidy}{The ploidy of the species being analyzed}

\item{output.file}{output file name (optional). If no output.file name provided, then a vcfR object will be returned.}
}
\value{
A gzipped vcf file
}
\description{
This function will filter a VCF file or vcfR object and export the updated version
}
\details{
This function will input a VCF file or vcfR object and filter based on the user defined options.
The output file will be saved to the location and with the name that is specified.
The VCF format is v4.3
}
\examples{
## Use file paths for each file on the local system

#Temp location (only for example)
output_file <- tempfile()

filterVCF(vcf.file = system.file("iris_DArT_VCF.vcf.gz", package = "BIGr"),
           filter.OD = 0.5,
           filter.MAF = 0.05,
           ploidy = 2,
           output.file = output_file)

# Removing the output for the example
rm(output_file)

##The function will output the filtered VCF to the current working directory

}
