% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGrid.r
\name{makeCircle}
\alias{makeCircle}
\title{Create the minimum circle containing the points}
\usage{
makeCircle(spdf, crs = NULL)
}
\arguments{
\item{spdf}{an object of class \sQuote{sf} or \sQuote{SpatialPointsDataFrame}
with defined CRS.}

\item{crs}{a number defining a projected CRS. It is very important
that the selected CRS is accurate in the study area. This is not the CRS for
the argument 'spdf' which should be defined internally. This is the CRS used to
make a flat circle. Some UTM variant is recommended. See \code{\link{getUTMproj}}}
}
\value{
a polygon object of class \sQuote{sf} with geodesic
coordinates in WGS84 (ESPG:4326).
}
\description{
This function is based on the function shotGroups::getMinCircle() that uses
the Skyum algorithm based on the convex hull. http://www.cs.au.dk/~gerth/slides/sven14.pdf
}
\seealso{
\code{\link{getUTMproj}}
}
