% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_beta_dists}
\alias{plot_beta_dists}
\title{Plot Beta Coefficients Distribution}
\usage{
plot_beta_dists(
  bktr_reg,
  labels_list,
  show_figure = TRUE,
  fig_width = 9,
  fig_height = 6,
  fig_resolution = 200
)
}
\arguments{
\item{bktr_reg}{BKTRRegressor: BKTRRegressor object.}

\item{labels_list}{List: List of labels tuple (spatial, temporal, feature) for
which to plot the beta distribution through iterations}

\item{show_figure}{Boolean: Whether to show the figure. Defaults to True.}

\item{fig_width}{Integer: Figure width. Defaults to 9.}

\item{fig_height}{Integer: Figure height. Defaults to 6.}

\item{fig_resolution}{Numeric: Figure resolution PPI. Defaults to 200.}
}
\value{
ggplot or NULL: ggplot object or NULL if show_figure is set to FALSE.
}
\description{
Plot the distribution of beta values for a given list of labels.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Launch MCMC sampling on a light version of the BIXI dataset
bixi_data <- BixiData$new(is_light = TRUE)
bktr_regressor <- BKTRRegressor$new(
  data_df <- bixi_data$data_df,
  spatial_positions_df = bixi_data$spatial_positions_df,
  temporal_positions_df = bixi_data$temporal_positions_df,
  burn_in_iter = 5, sampling_iter = 10) # For example only (too few iterations)
bktr_regressor$mcmc_sampling()

# Plot temporal beta coefficients for the first station and the first feature
spa_lab <- bixi_data$spatial_positions_df$location[3]
plot_beta_dists(
  bktr_regressor,
  labels_list = list(
     c(spa_lab, '2019-04-15', 'area_park'),
     c(spa_lab, '2019-04-16', 'area_park'),
     c(spa_lab, '2019-04-16', 'mean_temp_c')
  ),
)
\dontshow{\}) # examplesIf}
}
