% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_y_estimates}
\alias{plot_y_estimates}
\title{Plot Y Estimates}
\usage{
plot_y_estimates(
  bktr_reg,
  show_figure = TRUE,
  fig_width = 5,
  fig_height = 5,
  fig_resolution = 200,
  fig_title = "y estimates vs observed y values"
)
}
\arguments{
\item{bktr_reg}{BKTRRegressor: BKTRRegressor object.}

\item{show_figure}{Boolean: Whether to show the figure. Defaults to True.}

\item{fig_width}{Numeric: Figure width when figure is shown. Defaults to 5.}

\item{fig_height}{Numeric: Figure height when figure is shown. Defaults to 5.}

\item{fig_resolution}{Numeric: Figure resolution PPI when figure is shown. Defaults to 200.}

\item{fig_title}{String or NULL: Figure title if provided. Defaults to 'y estimates vs observed y values'}
}
\value{
ggplot or NULL: ggplot object or NULL if show_figure is set to FALSE.
}
\description{
Plot y estimates vs observed y values.
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Launch MCMC sampling on a light version of the BIXI dataset
bixi_data <- BixiData$new(is_light = TRUE)
bktr_regressor <- BKTRRegressor$new(
  data_df <- bixi_data$data_df,
  spatial_positions_df = bixi_data$spatial_positions_df,
  temporal_positions_df = bixi_data$temporal_positions_df,
  burn_in_iter = 5, sampling_iter = 10) # For example only (too few iterations)
bktr_regressor$mcmc_sampling()

# Plot Y estimates vs observed y values
plot_y_estimates(bktr_regressor)
\dontshow{\}) # examplesIf}
}
