% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot_results.R
\name{get_global_test_results}
\alias{get_global_test_results}
\title{Global Test Results for Transition Probabilities and Duration Times}
\usage{
get_global_test_results(results, decimal_pts = 2, include_plot = TRUE)
}
\arguments{
\item{results}{either results$results_trans or results$results_duration}

\item{decimal_pts}{specify the number of decimal points of the results; default is 2}

\item{include_plot}{display plot if TRUE; default is TRUE}
}
\value{
No return value, called for printing and plotting global test results.
}
\description{
For each covariate, print (and plot) the percentage of the number of clusters for each covariate in stored MCMC iterations.
}
\details{
The height of the bar represents the percentage of the number of the clusters within the stored MCMC samples. \cr
Pr(# clusters for covariate j ==1) is the probability for the null hypothesis that the covariate j is not significant
for transition probabilities or duration times, depending on the result type.
}
\examples{
results <- BMRMM(foxp2_sm,num_cov=2,simsize=50)
get_global_test_results(results$results_trans)
get_global_test_results(results$results_duration)

}
