% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_remit_call}
\alias{build_remit_call}
\title{Create an API call for REMIT flows}
\usage{
build_remit_call(
  data_item,
  api_key,
  event_start = NULL,
  event_end = NULL,
  publication_from = NULL,
  publication_to = NULL,
  participant_id = NULL,
  asset_id = NULL,
  event_type = NULL,
  fuel_type = NULL,
  message_type = NULL,
  message_id = NULL,
  unavailability_type = NULL,
  active_flag = NULL,
  sequence_id = NULL,
  service_type = "xml",
  api_version = "v1",
  ...
)
}
\arguments{
\item{data_item}{character string; the id of the REMIT flow}

\item{api_key}{character string; api key retrieved from the Elexon portal}

\item{event_start}{character string; event start (automatically cleaned by format_date)}

\item{event_end}{character string; event end (automatically cleaned by format_date)}

\item{publication_from}{character string; publication from (automatically cleaned by format_date)}

\item{publication_to}{character string; publication to (automatically cleaned by format_date)}

\item{participant_id}{character string; participant id}

\item{asset_id}{character string; asset id}

\item{event_type}{character string; event type}

\item{fuel_type}{character string; fuel type}

\item{message_type}{character string; message type}

\item{message_id}{character string; message id}

\item{unavailability_type}{character string; unavailability type}

\item{active_flag}{character string; active flag}

\item{sequence_id}{character string; sequence id}

\item{service_type}{character string; file format (csv or xml)}

\item{api_version}{character string; version of the api to use (currently on v1)}

\item{...}{additional parameters that will be appended onto the query string}
}
\value{
list; list with entries \code{url} for the call, \code{service_type} and \code{data_item}
}
\description{
Create an API call for REMIT flows
}
\examples{
build_remit_call(data_item = "MessageListRetrieval", api_key = "12345",
event_start = "14-12-2016", event_end = "15-12-2016")
build_remit_call(data_item = "MessageDetailRetrieval", api_key = "12345",
participant_id = 21, service_type = "xml")
}
\seealso{
Other call-building functions: 
\code{\link{build_b_call}()},
\code{\link{build_call}()},
\code{\link{build_legacy_call}()}
}
\concept{call-building functions}
