% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMT.R
\name{BMT}
\alias{BMT}
\alias{dBMT}
\alias{pBMT}
\alias{qBMT}
\alias{rBMT}
\title{The BMT Distribution.}
\usage{
dBMT(x, p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d",
  log = FALSE)

pBMT(q, p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d",
  lower.tail = TRUE, log.p = FALSE)

qBMT(p, p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d",
  lower.tail = TRUE, log.p = FALSE)

rBMT(n, p3, p4, type.p.3.4 = "t w", p1 = 0, p2 = 1, type.p.1.2 = "c-d")
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{p3, p4}{tails weights (\eqn{\kappa_l} and \eqn{\kappa_r}) or 
asymmetry-steepness (\eqn{\zeta} and \eqn{\xi}) parameters of the BMT 
distribution.}

\item{type.p.3.4}{type of parametrization asociated to p3 and p4. "t w" means
tails weights parametrization (default) and "a-s" means asymmetry-steepness
parametrization.}

\item{p1, p2}{domain (minimum and maximum) or location-scale (mean and 
standard deviation) parameters of the BMT ditribution.}

\item{type.p.1.2}{type of parametrization asociated to p1 and p2. "c-d" means
domain parametrization (default) and "l-s" means location-scale 
parametrization.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le 
x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the lenght is taken
to be the number required}
}
\value{
\code{dBMT} gives the density, \code{pBMT} the distribution function,
  \code{qBMT} the quantile function, and \code{rBMT} generates random 
  deviates.
  
  The length of the result is determined by \code{n} for \code{rBMT}, and is 
  the maximum of the lengths of the numerical arguments for the other 
  functions.
  
  The numerical arguments other than \code{n} are recycled to the length of 
  the result. Only the first elements of the logical arguments are used.
  
  If \code{type.p.3.4 == "t w"}, \code{p3 < 0} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  If \code{type.p.3.4 == "a-s"}, \code{p3 < -1} and \code{p3 > 1} are errors 
  and return \code{NaN}.
  
  \code{p4 < 0} and \code{p4 > 1} are errors and return \code{NaN}.
  
  If \code{type.p.1.2 == "c-d"}, \code{p1 >= p2} is an error and returns 
  \code{NaN}.
  
  If \code{type.p.1.2 == "l-s"}, \code{p2 <= 0} is an error and returns 
  \code{NaN}.
}
\description{
Density, distribution, quantile function, random number 
  generation for the BMT distribution, with \code{p3} and \code{p4} tails 
  weights (\eqn{\kappa_l} and \eqn{\kappa_r}) or asymmetry-steepness 
  parameters (\eqn{\zeta} and \eqn{\xi}) and \code{p1} and \code{p2} domain 
  (minimum and maximum) or location-scale (mean and standard deviation) 
  parameters.
}
\details{
The BMT distribution with tails weights and domain parametrization
  (\code{type.p.3.4 = "t w"} and \code{type.p.1.2 = "c-d"}) has quantile
  function \deqn{(d - c) [3 t_p ( 1 - t_p )^2 \kappa_l - 3 t_p^2 ( 1 - t_p )
  \kappa_r + t_p^2 ( 3 - 2 t_p ) ] + c} where \eqn{0 \le p \le 1}, \eqn{t_p =
  1/2 - \cos ( [\arccos ( 2 p - 1 ) - 2 \pi] / 3 )}, and \eqn{0 < \kappa_l <
  1} and \eqn{0 < \kappa_r < 1} are, respectively, related to left and right
  tail weights or curvatures.
  
  The BMT coefficient of asymmetry \eqn{-1 < \zeta < 1} is \deqn{\kappa_r - 
  \kappa_l}
  
  The BMT coefficient of steepness \eqn{0 < \xi < 1} is \deqn{(\kappa_r + 
  \kappa_l - |\kappa_r - \kappa_l|) / (2 (1 -  |\kappa_r - \kappa_l|))} for 
  \eqn{|\kappa_r - \kappa_l| < 1}.
}
\examples{
# BMT on [0,1] with left tail weight equal to 0.25 and 
# right tail weight equal to 0.75
z <- seq(0, 1, length.out = 100)
F1 <- pBMT(z, 0.25, 0.75, "t w")
Q1 <- qBMT(F1, 0.25, 0.75, "t w")
max(abs(z - Q1))
f1 <- dBMT(z, 0.25, 0.75, "t w")
r1 <- rBMT(100, 0.25, 0.75, "t w")
layout(matrix(c(1,2,1,3), 2, 2))
hist(r1, freq = FALSE, xlim = c(0,1))
lines(z, f1)
plot(z, F1, type="l")
plot(F1, Q1, type="l")

# BMT on [0,1] with asymmetry coefficient equal to 0.5 and 
# steepness coefficient equal to 0.5
F2 <- pBMT(z, 0.5, 0.5, "a-s")
Q2 <- qBMT(F2, 0.5, 0.5, "a-s")
f2 <- dBMT(z, 0.5, 0.5, "a-s")
r2 <- rBMT(100, 0.5, 0.5, "a-s")
max(abs(f1 - f2))
max(abs(F1 - F2))
max(abs(Q1 - Q2))

# BMT on [-1.783489, 3.312195] with 
# left tail weight equal to 0.25 and 
# right tail weight equal to 0.75
x <- seq(-1.783489, 3.312195, length.out = 100)
F3 <- pBMT(x, 0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")
Q3 <- qBMT(F3, 0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")
max(abs(x - Q3))
f3 <- dBMT(x, 0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")
r3 <- rBMT(100, 0.25, 0.75, "t w", -1.783489, 3.312195, "c-d")
layout(matrix(c(1,2,1,3), 2, 2))
hist(r3, freq = FALSE, xlim = c(-1.783489,3.312195))
lines(x, f3)
plot(x, F3, type="l")
plot(F3, Q3, type="l")

# BMT with mean equal to 0, standard deviation equal to 1, 
# asymmetry coefficient equal to 0.5 and 
# steepness coefficient equal to 0.5
f4 <- dBMT(x, 0.5, 0.5, "a-s", 0, 1, "l-s")
F4 <- pBMT(x, 0.5, 0.5, "a-s", 0, 1, "l-s")
Q4 <- qBMT(F4, 0.5, 0.5, "a-s", 0, 1, "l-s")
r4 <- rBMT(100, 0.5, 0.5, "a-s", 0, 1, "l-s")
max(abs(f3 - f4))
max(abs(F3 - F4))
max(abs(Q3 - Q4))

}
\references{
Torres-Jimenez, C. J. and Montenegro-Diaz, A. M. (2017, September), 
  \emph{An alternative to continuous univariate distributions supported on a 
  bounded interval: The BMT distribution}. ArXiv e-prints.
  
  Torres-Jimenez, C. J. (2017, September), \emph{Comparison of estimation methods 
  for the BMT distribution}. ArXiv e-prints.
  
  Torres-Jimenez, C. J. (2018), \emph{The BMT Item Response Theory model: A 
  new skewed distribution family with bounded domain and an IRT model based 
  on it}, PhD thesis, Doctorado en ciencias - Estadistica, Universidad 
  Nacional de Colombia, Sede Bogota.
}
\seealso{
\code{\link{BMTcentral}}, \code{\link{BMTdispersion}}, 
  \code{\link{BMTskewness}}, \code{\link{BMTkurtosis}}, 
  \code{\link{BMTmoments}} for descriptive measures or moments. 
  \code{\link{BMTchangepars}} for parameter conversion between different 
  parametrizations.
}
\author{
Camilo Jose Torres-Jimenez [aut,cre] \email{cjtorresj@unal.edu.co} 
  and Alvaro Mauricio Montenegro Diaz [ths]
}
\keyword{distribution}
