\name{tseriesca}
\alias{tseriesca}
\title{
Function for annual time series clustering. 
}
\description{
Function that performs the time series clustering algorithm described in Nieto-Barajas and Contreras-Cristan (2014) for annual time series data.
}
\usage{
tseriesca(data, maxiter = 1000, burnin = floor(0.1 * maxiter), 
          thinning = 5, level = FALSE, trend = TRUE, deg = 2, c0eps = 2, 
          c1eps = 1, c0beta = 2, c1beta = 1, c0alpha = 2, c1alpha = 1, 
          priora = FALSE, pia = 0.5, q0a = 1, q1a = 1, priorb = FALSE,
          q0b = 1, q1b = 1, a = 0.25, b = 0, indlpml = FALSE)
}
\arguments{
  \item{data}{
Data frame with the time series information. 
}
  \item{maxiter}{
Maximum number of iterations for Gibbs sampling.
}
  \item{burnin}{
Burn-in period of the Markov Chain generated by Gibbs sampling. 
}
  \item{thinning}{
Number that indicates how many Gibbs sampling simulations should be skipped to form the Markov Chain.
}
  \item{level}{
Flag that indicates if the level of the time series will be considered for clustering. If TRUE, then it is taken into account.
}
  \item{trend}{
Flag that indicates if the polinomial trend of the model will be considered for clustering. If TRUE, then it is taken into account.
}
  \item{deg}{
Degree of the polinomial trend of the model.
}
  \item{c0eps}{
Shape parameter of the hyper-prior distribution on sig2eps.
}
  \item{c1eps}{
Rate parameter of the hyper-prior distribution on sig2eps. 
}
  \item{c0beta}{
Shape parameter of the hyper-prior distribution on sig2beta. 
}
  \item{c1beta}{
Rate parameter of the hyper-prior distribution on sig2beta. 
}
  \item{c0alpha}{
Shape parameter of the hyper-prior distribution on sig2alpha. 
}
  \item{c1alpha}{
Rate parameter of the hyper-prior distribution on sig2alpha. 
}
  \item{priora}{
Flag that indicates if a prior on parameter "a" is to be assigned. If TRUE, a prior on "a" is assigned.
}
  \item{pia}{
Mixing proportion of the prior distribution on parameter "a".
}
  \item{q0a}{
Shape parameter of the continuous part of the prior distribution on parameter "a". 
}
  \item{q1a}{
Shape parameter of the continuous part of the prior distribution on parameter "a".
}
  \item{priorb}{
Flag that indicates if a prior on parameter "b" is to be assigned. If TRUE, a prior on "b" is assigned.
}
  \item{q0b}{
Shape parameter of the prior distribution on parameter "b". 
}
  \item{q1b}{
Shape parameter of the prior distribution on parameter "b". 
}
  \item{a}{
Initial/fixed value of parameter "a".
}
  \item{b}{
Initial/fixed value of parameter "b".
}
  \item{indlpml}{
Flag that indicates if the LPML is to be calculated. If TRUE, LPML is calculated.
}
}

\details{
It is assumed that the time series data is organized into a data frame with the time periods included as its row names. 
}
\value{
\item{mstar}{Number of groups of the chosen cluster configuration.}
\item{gnstar}{Array that contains the group number to which each time series belongs.}
\item{HM}{Heterogeneity Measure of the chosen cluster configuration.} 
\item{arrho}{Acceptance rate of the parameter "rho".}
\item{ara}{Acceptance rate of the parameter "a".}
\item{arb}{Acceptance rate of the parameter "b".}
\item{sig2epssample}{Matrix that in its columns contains the sample of each sig2eps_i's posterior distribution after Gibbs sampling.}
\item{sig2alphasample}{Matrix that in its columns contains the sample of each sig2alpha_i's posterior distribution after Gibbs sampling.}
\item{sig2betasample}{Matrix that in its columns contains the sample of each sig2beta_i's posterior distribution after Gibbs sampling.}
\item{sig2thesample}{Vector that contains the sample of sig2the's posterior distribution after Gibbs sampling.} 
\item{rhosample}{Vector that contains the sample of rho's posterior distribution after Gibbs sampling.}
\item{asample}{Vector that contains the sample of a's posterior distribution after Gibbs sampling.}
\item{bsample}{Vector that contains the sample of b's posterior distribution after Gibbs sampling.}
\item{msample}{Vector that contains the sample of the number of groups at each Gibbs sampling iteration.}
\item{lpml}{If indlpml = TRUE, lpml contains the value of the LPML of the chosen model.}
}
\author{
Martell-Juarez, D.A. and Nieto-Barajas, L.E.
}
\examples{
## Do not run
#
# data(gdp)
# tseriesca.out <- tseriesca(gdp,maxiter = 4000,level=FALSE,trend=TRUE,
#                            c0eps = 0.001,c1eps = 0.001,c0beta = 0.001,
#                            c1beta = 0.001,c0alpha = 0.001,
#                            c1alpha= 0.001,priorb = TRUE,a = 0,b = 0.1)
#
# The console output of the above example is:
# 
# Number of groups of the chosen cluster configuration : 13
# Time series in group 1 : 1 111
# Time series in group 2 : 2 8
# Time series in group 3 : 3 4 5 6 7 10 11 12 13 14 15 16 17 18 19 20 21
# 22 24 25 26 28 29 30 31 32 33 34 35 36 37 38 40 41 42 43 44 45 46 47 49
# 50 51 52 55 56 57 58 59 61 62 63 65 67 68 69 70 71 74 75 76 77 78 79 80
# 81 82 83 84 85 86 89 92 92 93 94 95 96 97 100 101 102 103 104 105 106
# 107 108 109 110 113 114 117 118 120
# Time series in group 4 : 9 23 48 54 60 87
# Time series in group 5 : 27
# Time series in group 6 : 39
# Time series in group 7 : 53 73 88
# Time series in group 8 : 64
# Time series in group 9 : 66 98 112
# Time series in group 10 : 72
# Time series in group 11 : 90 116 119 121
# Time series in group 12 : 99
# Time series in group 13 : 115 
# HM Measure : 99.50627
#
# Make sure that chain convergence is always assessed. Run the following 
# code to show the cluster and diagnostic plots:

data(gdp)
data(tseriesca.out)
attach(tseriesca.out)

clusterplots(tseriesca.out,gdp)
diagplots(tseriesca.out)

}