% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvInv.R
\name{MvInv}
\alias{MvInv}
\title{Invert jump heights function}
\usage{
MvInv(eps, u = 0.5, alpha = 1, beta = 1, gama = 1/2, N = 3001)
}
\description{
Determines the jump heights of an increasing additive process by inverting
the M(v) function.
}
\details{
For internal use.
}
\examples{

## The function is currently defined as
function(eps, u = 0.5, alpha = 1, beta = 1, gama = 1 / 2, N = 3001) {
  n <- length(w)
  v <- rep(NA, n)
  x <- -log(seq(from = exp(-1e-05), to = exp(-10), length = N))
  f <- alpha / gamma(1 - gama) * x^(-(1 + gama)) * exp(-(u +
    beta) * x)
  dx <- diff(x)
  h <- (f[-1] + f[-N]) / 2
  Mv <- rep(0, N)
  for (i in seq(N - 1, 1)) Mv[i] <- Mv[i + 1] + dx[i] * h[i]
  for (j in seq(n)) v[j] <- x[which.min(Mv > w[j])]
  return(v)
}
}
\keyword{internal}
