% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condMCMCmv.R
\name{condMCMCmv}
\alias{condMCMCmv}
\title{MCMC for multivariate Pitman-Yor mixtures}
\usage{
condMCMCmv(data, grid = NULL, niter, nburn, m0 = NULL, k0 = NULL,
  S0 = NULL, n0 = NULL, mass = 1, method = "ICS", napprox = 100,
  nupd = 1000, out_param = F, out_dens = TRUE, process = "DP",
  sigma_PY = 0, print_message = TRUE, light_dens = TRUE)
}
\arguments{
\item{data}{A dataset (matrix).}

\item{grid}{A grid of points to evaluate the estimated density (matrix).}

\item{niter}{Number of iterations to estimate the model.}

\item{nburn}{Number of burn-in iterations.}

\item{m0}{Mean of location component of the base measure.}

\item{k0}{Tuning parameter of the variance for the location component of the base measure.}

\item{S0}{Matrix of the Inverse Wishart distribution of the scale component.}

\item{n0}{Degree of freedom of the Inverse Wishart distribution of the scale component.}

\item{mass}{Mass parameter.}

\item{method}{Different methods to estimate the model. Possible vaule "ICS", "SLI" or "MAR",
importance conditional sampler/slice sampler/marginal sampler, default "ICS".}

\item{napprox}{Number of values to be sampled from the restricted process via "ICS" method, default 100.}

\item{nupd}{How frequently show the curren state of the estimation (number of iterations) - default 1000.}

\item{out_param}{If TRUE, save the parameters for each iteration, default FALSE.}

\item{out_dens}{If TRUE, return also the estimated density, default TRUE.}

\item{process}{Dirichlet process ("DP") or Pitman-Yor process ("PY"), default "DP".}

\item{sigma_PY}{Discount parameter of the Pitman-Yor process, default 0.}

\item{print_message}{If TRUE print the status of the estimation, default TRUE.}

\item{light_dens}{If TRUE return only the mean of the estimated densities, default TRUE.}
}
\value{
A modCondMv class object contain the estimated density for each iterations,
the allocations for each iterations. If out_param is TRUE, also the parameters for each iteration.
}
\description{
The condMCMCmv function estimate a multivariate Pitman-Yor process mixture model with
Gaussian kernel. Three possible sampling strategies: importance conditional sampler,
slice sampler and marginal sampler.

The models are of the form \deqn{\tilde f(\mathbf x) = \int k(\mathbf x; \mathbf \mu, \Sigma) \tilde p (d \mathbf \mu, d \Sigma)} where
\eqn{k(\mathbf x; \mathbf \mu, \Sigma)} is a multivariate gaussian kernel function, \eqn{\tilde p} is distributed as a Pitman-Yor
process with total mass \eqn{\vartheta}, discount parameter \eqn{\sigma} and normal-inverse-wishart base measure \eqn{P_0}, i.e.
\deqn{P_0 \sim N(\mathbf \mu; \mathbf m_0, k_0 \Sigma) \times IW(\Sigma; n_0, S_0).}
}
\examples{
data_toy <- cbind(c(rnorm(100, -3, 1), rnorm(100, 3, 1)),
                  c(rnorm(100, -3, 1), rnorm(100, 3, 1)))
grid <- expand.grid(seq(-7, 7, length.out = 50),
                    seq(-7, 7, length.out = 50))
est_model <- condMCMCmv(data = data_toy, grid = grid, niter = 1000,
                       nburn = 100, napprox = 100, nupd = 100)
summary(est_model)
plot(est_model)

}
