% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.BRBVS}
\alias{summary.BRBVS}
\title{Summary for BRBVS Object}
\usage{
\method{summary}{BRBVS}(object, ...)
}
\arguments{
\item{object}{An object of class \code{BRBVS}, typically the result of a BRBVS analysis.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
This function does not return a value but prints the summary of the BRBVS object to the console.
If the \code{BRBVS} object is invalid or incomplete, an error message is displayed and the function returns \code{NULL}.
}
\description{
Provides a concise overview of a Bivariate Variable  Selection (BRBVS) object.
It reports the maximum number of relevant covariates (\code{kmax}) across all sets, and details
the relevant covariates for each survival function along with their frequency of selection.
}
\examples{
############################
# Toy Example
############################
BRBVS_object <- list(
mtx.act1E = c("z2", "z1", "0", "0"),
scores1E = c(20, 1, 1),
freq.rel1E = c(1, 1, 1, 1),
mtx.act2E = c("z2", "z1", "0", "0"),
scores2E = c(20, 1, 1),
freq.rel2E = c(1, 1, 1, 1),
metric = "FIM",
kmax = 4,
copula = "C0",
margins = c("PO", "PO"),
tau = 0.5,
Namecondings = matrix(
 c("z1", "z1", "z2", "z2", "z3", "z3", "z4", "z4", "z5", "z5", "z6", "z6"),
 nrow = 6, ncol = 2, byrow = TRUE,
 dimnames = list(NULL, c("Features", "Code"))
)
)

class(BRBVS_object) <- "BRBVS"
summary(BRBVS_object)

}
