% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{run_asymmetric_mcmc}
\alias{run_asymmetric_mcmc}
\title{Run the BSBT MCMC algorithm with n types of individuals and asymmetric variance}
\usage{
run_asymmetric_mcmc(
  n.iter,
  delta,
  covariance.matrix,
  win.matrices,
  estimates.initial,
  omega = 0.1,
  chi = 0.1
)
}
\arguments{
\item{n.iter}{The number of iterations to be run}

\item{delta}{The underrlaxed tuning parameter must be in (0, 1)}

\item{covariance.matrix}{The output from the covariance matrix function, which contains the decomposed and inverted covariance matrix. The variance hyperparameter must be set to 1.}

\item{win.matrices}{A list of n matrices where the ith matrix is the win matrix corresponding to only the ith level}

\item{estimates.initial}{A list of vectors where the ith vector is the initial estimate for the ith level effect}

\item{omega}{The value of the inverse gamma shape parameter}

\item{chi}{The value of the inverse gamma scale parameter}
}
\value{
A list of MCMC output
\itemize{
\item estimates - A list of matrices. Each matrix containing the iteration of the ith level
\item alpha.sq - A matrix containing the iterations of alpha^2
\item acceptance.rate - The acceptance rate for f and g
\item time.taken - Time taken to run the MCMC algorithm in seconds
}
}
\description{
This function runs the MCMC algorithm with n types of individuals, for example male and female. The types must share the same covariance matrix and the win matrices are entered as a list. The first item in the list acts as the baseline group. This model has an asymmetric variance structure, as the variance of the baseline is always smaller.
For a model with thee types, f, g and h, the structure is as follows. The baseline is f, or the second type, g = f + d_1, and the third type, h = f + d_2. Here d_1 and d_2 are the discrepancy between each type and the baseline.
}
\examples{

n.iter <- 10
delta <- 0.1
covariance.matrix <- list()
covariance.matrix$mean <- c(0, 0, 0)
covariance.matrix$decomp <- diag(3)
covariance.matrix$inv    <- diag(3)
men.comparisons <- data.frame("winner" = c(1, 3, 2, 2), "loser" = c(3, 1, 1, 3))
women.comparisons <- data.frame("winner" = c(1, 2, 1, 2), "loser" = c(3, 1, 3, 3))
men.win.matrix <- comparisons_to_matrix(3, men.comparisons)
women.win.matrix <- comparisons_to_matrix(3, women.comparisons)
f.initial <- c(0, 0, 0)
g.initial <- c(0, 0, 0)

win.matrices <- list(men.win.matrix, women.win.matrix)
estimates.initial <- list(f.initial, g.initial)

mcmc.output<- run_asymmetric_mcmc(n.iter, delta, covariance.matrix, win.matrices, estimates.initial)

}
