% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Ratings}
\alias{Ratings}
\title{Grade point averages versus teacher's ratings}
\format{
A data frame/tibble with 250 observations on two variables
\describe{
\item{rating}{character variable with students' ratings of instructor (A-F)}
\item{gpa}{students' grade point average}
}
}
\usage{
Ratings
}
\description{
Data for Example 2.6
}
\examples{

boxplot(gpa ~ rating, data = Ratings, xlab = "Student rating of instructor", 
        ylab = "Student GPA")
\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Ratings, aes(x = rating, y = gpa, fill = rating)) +
           geom_boxplot() + 
           theme_bw() + 
           theme(legend.position = "none") + 
           labs(x = "Student rating of instructor", y = "Student GPA")
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
