% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.EstimateParameters}
\alias{bgcnbd.EstimateParameters}
\alias{mbgcnbd.EstimateParameters}
\alias{mbgnbd.EstimateParameters}
\title{(M)BG/CNBD-k Parameter Estimation}
\usage{
mbgcnbd.EstimateParameters(cal.cbs, k = NULL, par.start = c(1, 3, 1, 3),
  max.param.value = 10000, trace = 0)

bgcnbd.EstimateParameters(cal.cbs, k = NULL, par.start = c(1, 3, 1, 3),
  max.param.value = 10000, trace = 0)

mbgnbd.EstimateParameters(cal.cbs, par.start = c(1, 3, 1, 3),
  max.param.value = 10000, trace = 0)
}
\arguments{
\item{cal.cbs}{Calibration period customer-by-sufficient-statistic (CBS)
data.frame. It must contain a row for each customer, and columns \code{x}
for frequency, \code{t.x} for recency , \code{T.cal} for the total time
observed, as well as the sum over logarithmic intertransaction times
\code{litt}, in case that \code{k} is not provided. A correct format can be
easily generated based on the complete event log of a customer cohort with
\code{\link{elog2cbs}}.}

\item{k}{Integer-valued degree of regularity for Erlang-k distributed
interpurchase times. By default this \code{k} is not provided, and a grid
search from 1 to 12 is performed in order to determine the best-fitting
\code{k}. The grid search is stopped early, if the log-likelihood does not
increase anymore when increasing k beyond 4.}

\item{par.start}{Initial (M)BG/CNBD-k parameters. A vector with \code{r},
\code{alpha}, \code{a} and \code{b} in that order.}

\item{max.param.value}{Upper bound on parameters.}

\item{trace}{If larger than 0, then the parameter values are is printed every
\code{trace}-step of the maximum likelihood estimation search.}
}
\value{
A vector of estimated parameters.
}
\description{
Estimates parameters for the (M)BG/CNBD-k model via Maximum Likelihood
Estimation.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
(params <- mbgcnbd.EstimateParameters(cbs))
}
}
\references{
(M)BG/CNBD-k: Platzer Michael, and Thomas Reutterer (submitted)

MBG/NBD: Batislam, E.P., M. Denizel, A. Filiztekin. 2007.
  Empirical validation and comparison of models for customer base analysis.
  International Journal of Research in Marketing 24(3) 201-209.
}
\seealso{
\code{\link[BTYD]{bgnbd.EstimateParameters}}
}

