#' BVAR: Hierarchical Bayesian Vector Autoregression
#'
#' Estimation of hierarchical Bayesian vector autoregressive models.
#' Implements hierarchical prior selection for conjugate priors in the fashion
#' of Giannone, Lenza & Primiceri (2015) <doi:10.1162/REST_a_00483>. Functions
#' to compute and identify impulse responses, calculate forecasts,
#' forecast error variance decompositions and scenarios are available.
#' Several methods to print, plot and summarise results facilitate analysis.
#'
#' @docType package
#'
#' @name BVAR-package
#'
#' @references
#'   Giannone, D. and Lenza, M. and Primiceri, G. E. (2015) Prior Selection for
#'   Vector Autoregressions. \emph{The Review of Economics and Statistics},
#'   \bold{97:2}, 436-451, \url{https://doi.org/10.1162/REST_a_00483}.
#'
#'   Kuschnig, N. and Vashold, L. (2019) BVAR: Bayesian Vector Autoregressions
#'   with Hierarchical Prior Selection in R. \emph{Department of Economics
#'   Working Paper Series}, \bold{296}, WU Vienna University of Economics and
#'   Business, \url{https://doi.org/10.13140/RG.2.2.25541.60643}.

#'
NULL
