% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/60_irf_setup.R
\name{bv_irf}
\alias{bv_irf}
\title{Impulse response settings and identification}
\usage{
bv_irf(
  horizon = 12,
  fevd = FALSE,
  identification = TRUE,
  sign_restr = NULL,
  zero_restr = NULL,
  sign_lim = 1000
)
}
\arguments{
\item{horizon}{Integer scalar. The horizon for which impulse responses
(and FEVDs) should be computed. Note that the first period corresponds to
impacts i.e. contemporaneous effects.}

\item{fevd}{Logical scalar. Whether or not forecast error variance
decompositions should be calculated.}

\item{identification}{Logical scalar. Whether or not the shocks used for
calculating impulses should be identified. Defaults to \code{TRUE}, i.e.
identification via Cholesky decomposition of the VCOV-matrix unless
\emph{sign_restr} is provided.}

\item{sign_restr}{Numeric matrix. Sign restrictions for identification.
Elements should be set to 1 (-1) to restrict for positive
(negative) impacts. If no presumption about the impact can be made the
corresponding elements can be set to \code{NA}. The default value is
\code{NULL}, meaning identification would be performed via Cholesky
decomposition. Note that in order to be fully identified at least
\eqn{M * (M - 1) / 2} restrictions have to be set.}

\item{zero_restr}{Numeric matrix. Zero and sign restrictions for
identification. \emph{Currently not functional.}}

\item{sign_lim}{Integer scalar. Maximum number of rotational matrices to
draw and check for fitting sign restrictions.}
}
\value{
Returns a named list of class \code{bv_irf} with options for
\code{\link{bvar}}, \code{\link{irf.bvar}} or \code{\link{fevd.bvar}}.
}
\description{
Provides settings for the computation of impulse responses to
\code{\link{bvar}}, \code{\link{irf.bvar}} or \code{\link{fevd.bvar}}. Allows
setting the horizon for which impulse responses should be computed, whether
or not forecast error variance decompositions (FEVDs) should be included
and if and what kind of identification should be used.
}
\details{
Identification can be performed via Cholesky decomposition and sign
restrictions. The algorithm for generating suitable sign restrictions
follows Rubio-Ramirez, Waggoner and Zha (2010).
Note the possiblity of finding no suitable sign restrictions.
}
\examples{
# Set impulse responses to a horizon of 20 time periods and enable FEVD
# (Identification is performed via Cholesky decomposition)
bv_irf(horizon = 20, fevd = TRUE)

# Set up structural impulse responses using sign restrictions
signs <- matrix(c(1, NA, NA, -1, 1, -1, -1, 1, 1), nrow = 3)
bv_irf(sign_restr = signs)

# Prepare to estimate unidentified impulse responses
bv_irf(identification = FALSE)
}
\references{
Rubio-Ramirez, J. F. and Waggoner, D. F. and Zha, T. (2010) Structural
  Vector Autoregressions: Theory of Identification and Algorithms for
  Inference. \emph{The Review of Economic Studies}, \bold{77}, 665-696,
  \url{https://doi.org/10.1111/j.1467-937X.2009.00578.x}.
}
\seealso{
\code{\link{irf.bvar}}; \code{\link{plot.bvar_irf}}
}
\keyword{BVAR}
\keyword{fevd}
\keyword{irf}
\keyword{settings}
