% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{getArena}
\alias{getArena}
\alias{getArena,Eval-method}
\title{Function for re-constructing an Arena object from a simulation step}
\usage{
getArena(object, time = (length(object@medlist) - 1))

\S4method{getArena}{Eval}(object, time = (length(object@medlist) - 1))
}
\arguments{
\item{object}{An object of class Eval.}

\item{time}{A number giving the simulation step of interest.}
}
\value{
Returns an object of class \code{Arena} containing the organisms and substance conditions in simulation step \code{time}.
}
\description{
The generic function \code{getArena} re-constructs an \code{Arena} object from a simulation step within an \code{Eval} object.
}
\details{
The function \code{addEval} can be used to manipulate an \code{Arena} object from a simulation step to modify the subsequent simulation steps.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
arena5 <- getArena(eval,5)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}
