% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{plot_hist}
\alias{plot_hist}
\title{Plot histogram from MCMC samples}
\usage{
plot_hist(
  samples,
  title = "",
  xlab = "Values",
  ylab = "Frequency",
  color = "black",
  fill = "blue",
  binwidth = 0.05,
  scale_x = FALSE
)
}
\arguments{
\item{samples}{data.frame containing the discrete MCMC samples}

\item{title}{title of the plot, default is none}

\item{xlab}{x-label of the plot, default is "Values"}

\item{ylab}{y-label of the plot, default is "Frequency"}

\item{color}{outline color for the bars, default is "black"}

\item{fill}{fill color, default is "blue"}

\item{binwidth}{width of the histogram bins, default is 0.5}

\item{scale_x}{option to scale the x-axis, suitable for discrete samples, 
default is FALSE}
}
\value{
a ggplot2 object
}
\description{
Plots a histogram of the given discrete MCMC samples
}
\examples{
data(weibull_cc, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(weibull_cc$tte, c(0.5, 1.0), names = FALSE))
initial_param <- list("J" = 1, 
                      "s_r" = s[2], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = c(1, 1), 
                       "beta" = 0)

# run the MCMC sampler CHANGE THIS BEFORE FINAL CHECK
out <- BayesFBHborrow(weibull_cc, NULL, initial_param,
                iter = 10, warmup_iter = 1)

# Plot the frequency of the number of split points, J with a histogram
time_grid <- seq(0, max(s), length.out = 2000)
gg <- plot_hist(out$out_fixed$J, title = "Example histogram of J",
                scale_x = TRUE)
}
