% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{likelihood.seqtoone_tdist}
\alias{likelihood.seqtoone_tdist}
\title{Use a T-likelihood for a seq-to-one recurrent network.}
\usage{
likelihood.seqtoone_tdist(chain, sig_prior, nu = 30)
}
\arguments{
\item{chain}{Network structure obtained using \code{link{Chain}}}

\item{sig_prior}{A prior distribution for sigma defined using
\code{\link{Gamma}}, \code{link{InverGamma}},
\code{\link{Truncated}}, \code{\link{Normal}}}

\item{nu}{DF of TDist}
}
\value{
see \code{\link{likelihood.feedforward_normal}}
}
\description{
See \code{\link{likelihood.seqtoone_normal}} and \code{\link{likelihood.feedforward_tdist}}
for details,
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(RNN(5, 1))
  like <- likelihood.seqtoone_tdist(net, Gamma(2.0, 0.5), nu=5)
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- array(rnorm(5*100*10), dim=c(10,5,100))
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  BNN.totparams(bnn)
}

}
