% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesFluxR.R
\name{BayesFluxR_setup}
\alias{BayesFluxR_setup}
\title{Set up of the Julia environment needed for BayesFlux}
\usage{
BayesFluxR_setup(
  pkg_check = TRUE,
  nthreads = 4,
  seed = NULL,
  env_path = getwd(),
  installJulia = FALSE,
  ...
)
}
\arguments{
\item{pkg_check}{(Default=TRUE) Check whether needed Julia packages
are installed}

\item{nthreads}{(Default=4) How many threads to make available to Julia}

\item{seed}{Seed to be used.}

\item{env_path}{The path to were the Julia environment should be created.
By default, this is the current working directory.}

\item{installJulia}{(Default=TRUE) Whether to install Julia}

\item{...}{Other parameters passed on to \code{\link[JuliaCall]{julia_setup}}}
}
\value{
No return value, called for side effects.
}
\description{
This will set up a new Julia environment in the current working
directory or another folder if provided. This environment will
then be set with all Julia dependencies needed.
}
\examples{
\dontrun{
  ## Time consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
}
}
