context("Testing that the random numbers are equal between platforms")

bmm <- compute_mallows_mixtures(n_clusters = c(1, 4),
                                rankings = sushi_rankings, nmc = 50,
                                save_clus = FALSE, include_wcd = FALSE, seed = 432)

expect_equal(bmm[[2]]$cluster_probs$value[1:50],
             c(0.25, 0.25, 0.25, 0.25, 0.250115858981958, 0.245833894814954,
               0.24776442243802, 0.256285823765068, 0.259755910577542, 0.254278492152845,
               0.243691388351727, 0.242274208917887, 0.256930502690792, 0.26457315376412,
               0.249646090352651, 0.228850253192436, 0.285147955560069, 0.2590389030129,
               0.24520920027659, 0.21060394115044, 0.321489749362278, 0.242350236575651,
               0.239852538139751, 0.19630747592232, 0.355038096524565, 0.2519814366835,
               0.212692958695879, 0.180287508096056, 0.425605136044314, 0.238233258441893,
               0.191547594271449, 0.144614011242345, 0.471560126575566, 0.22789003535249,
               0.172800437789403, 0.127749400282541, 0.529283171450281, 0.213611416839764,
               0.162162944822039, 0.0949424668879162, 0.571345722054402, 0.218742041345345,
               0.14193372161001, 0.0679785149902439, 0.590911805649289, 0.214333208163341,
               0.147308890657558, 0.0474460955298128, 0.589088229731664, 0.216858699623055
             ))


m <- compute_mallows(sushi_rankings, n_clusters = 5, seed = 123, nmc = 20)

expect_equal(m$cluster_probs$value,
             c(0.2, 0.2, 0.2, 0.2, 0.2, 0.211429132832491, 0.187035286787252,
               0.199569648079635, 0.196576755493794, 0.205389176806829, 0.214223210442586,
               0.178568753065652, 0.204515140116042, 0.206068907883878, 0.196623988491842,
               0.207781052898258, 0.200394048359074, 0.171738648277441, 0.211189039818989,
               0.208897210646238, 0.208501128303555, 0.224085418874196, 0.108014895498171,
               0.250253500757745, 0.209145056566333, 0.171456738094347, 0.269992404255491,
               0.0598891742977972, 0.276137782967676, 0.22252390038469, 0.133305565141434,
               0.356800801937652, 0.0400176719942964, 0.261391861968398, 0.208484098958219,
               0.103335794373015, 0.476214607385356, 0.0248120893907287, 0.218315717292425,
               0.177321791558475, 0.0738109784531863, 0.574149889623057, 0.0167130737055734,
               0.192686493106398, 0.142639565111785, 0.0507232531658093, 0.660396466513286,
               0.0150634690106238, 0.171778186318466, 0.102038624991816, 0.0361769260560982,
               0.707666608104996, 0.0117275388968194, 0.16059463525242, 0.0838342916896657,
               0.0261268227960779, 0.726209869365256, 0.00749320700640763, 0.161694998871202,
               0.0784751019610561, 0.0189334508454402, 0.748115213465995, 0.00743808564141656,
               0.154731539016908, 0.0707817110302405, 0.0145083864894219, 0.769767498079076,
               0.00952271253591297, 0.147967596090508, 0.0582338068050813, 0.0157585744300619,
               0.763652099012315, 0.0053851238401151, 0.148319760492099, 0.0668844422254092,
               0.0137697693232038, 0.773604965444498, 0.00400489808396823, 0.145445007863842,
               0.0631753592844881, 0.0139314238129272, 0.750803635486729, 0.00324079940192409,
               0.157375319123961, 0.0746488221744583, 0.0105265343903905, 0.745499859468268,
               0.00504671698146696, 0.166976880188279, 0.0719500089715952, 0.00995308255643108,
               0.745948892951975, 0.00816701525067477, 0.162765307650426, 0.0731657015904927,
               0.00738112161901393, 0.705379006555873, 0.00582127027645978,
               0.190163176430672, 0.0912554251179818))
