% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{smc_mallows_new_users_complete}
\alias{smc_mallows_new_users_complete}
\title{SMC-Mallows New Users Complete}
\usage{
smc_mallows_new_users_complete(
  R_obs,
  n_items,
  metric,
  leap_size,
  N,
  Time,
  mcmc_kernel_app,
  num_new_obs,
  alpha_prop_sd,
  lambda,
  alpha_max,
  logz_estimate = NULL,
  verbose = FALSE
)
}
\arguments{
\item{R_obs}{Matrix containing the full set of observed rankings of size
n_assessors by n_items}

\item{n_items}{Integer is the number of items in a ranking}

\item{metric}{A character string specifying the distance metric to use
in the Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}

\item{leap_size}{leap_size Integer specifying the step size of the
leap-and-shift proposal distribution}

\item{N}{Integer specifying the number of particles}

\item{Time}{Integer specifying the number of time steps in the SMC algorithm}

\item{mcmc_kernel_app}{Integer value for the number of applications we
apply the MCMC move kernel}

\item{num_new_obs}{Integer value for the number of new observations
(complete rankings) for each time step}

\item{alpha_prop_sd}{Numeric value specifying the standard deviation of the
lognormal proposal distribution used for \eqn{\alpha} in the
Metropolis-Hastings algorithm. Defaults to \code{0.1}.}

\item{lambda}{Strictly positive numeric value specifying the rate parameter
of the truncated exponential prior distribution of \eqn{\alpha}. Defaults
to \code{0.1}. When \code{n_cluster > 1}, each mixture component
\eqn{\alpha_{c}} has the same prior distribution.}

\item{alpha_max}{Maximum value of \code{alpha} in the truncated exponential
prior distribution.}

\item{logz_estimate}{Estimate of the partition function, computed with
\code{\link{estimate_partition_function}} in the BayesMallow R package
{estimate_partition_function}.}

\item{verbose}{Logical specifying whether to print out the progress of the
SMC-Mallows algorithm. Defaults to \code{FALSE}.}
}
\value{
a set of particles each containing a value of rho and alpha
}
\description{
Function to perform resample-move SMC algorithm where we
receive new users with complete rankings at each time step
}
\examples{
# Generate basic elements
data <- sushi_rankings[1:100, ]
n_items <- ncol(sushi_rankings)
metric <- "footrule"
num_new_obs <- 10
logz_estimate <- estimate_partition_function(
	method = "importance_sampling",
	alpha_vector = seq(from = 0, to = 15, by = 0.1),
	n_items = n_items, metric = metric, nmc = 1e2, degree = 10
)

# Calculating rho and alpha samples
samples <- smc_mallows_new_users_complete(
	R_obs = data, n_items = n_items, metric = metric,
	leap_size = floor(n_items / 5), N = 100, Time = nrow(data) / num_new_obs,
	mcmc_kernel_app = 5, logz_estimate = logz_estimate,
	alpha_prop_sd = 0.1, lambda = 0.001, alpha_max = 1e6,
	num_new_obs = num_new_obs, verbose = TRUE
)

# Studying the structure of the output
str(samples)
}
