% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectancy_default.R
\name{expectancy}
\alias{expectancy}
\title{Generic expectancy function}
\usage{
expectancy(x, ...)
}
\arguments{
\item{x}{Object of one of these class: \code{HP}, \code{DLM}, \code{BLC}, \code{ClosedHP}, \code{ClosedDLM}, \code{BLC}, or \code{PredBLC}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data.frame and (if graph = TRUE) a plot for \code{HP}, \code{DLM}, \code{ClosedHP} and \code{ClosedDLM} methods.
A list that contains three vectors with the fitted values of life expectancy and the lower and upper limits of the credible intervals for each year used in fitted model or for the prediction, for \code{BLC} and \code{PredBLC} methods.
}
\description{
Generic function to \code{expectancy} method.
}
\details{
This function computes the life expectancy given by:

\eqn{e_x = \sum tp_x}

where:

\eqn{tp_x = p_0 x p_1 x ... x p_x}
}
\seealso{
\code{\link[=expectancy.HP]{expectancy.HP()}}, \code{\link[=expectancy.DLM]{expectancy.DLM()}} and \code{\link[=expectancy.BLC]{expectancy.BLC()}}.
}
