% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_mcmc.R
\name{plots_mcmc}
\alias{plots_mcmc}
\title{Plots SFM MCMC output.}
\usage{
plots_mcmc(sfm_mcmc, S)
}
\arguments{
\item{sfm_mcmc}{a list. Output of `sfm_mcmc_spmix()` containing the parameter draws from the posterior distribution at each MCMC iteration.}

\item{S}{(a number between 0 and 1) The first S*M draws will be discarded as a burn-in. M is the total number of MCMC iterations.}
}
\value{
A list showing :
\itemize{
       \item 1: Trace plots of pre-processed draws;
       \item 2: The posterior distribution of each parameter after post-processing;
       \item 3: The posterior probability of the number of components after post-processing;
       \item 4: Estimated mixture density after post-processing at each iteration and histogram of the data.
}
}
\description{
Show plots of the MCMC estimation.
}
\examples{
# Example with simulated data ================================================
#set seed for random number generation
set.seed(1) 

# Set the parameters for drawing from a two-component shifted Poisson mixture
p1 = 0.3
p2 = 1-p1
kap1 = 3
kap2 = 0
lam1 = 1
lam2 = 0.5
length_data = 70

# Generate data
y <- c(rpois(length_data*p1, lam1)+kap1, rpois(length_data*p2, lam2)+kap2)

# Set parameters for the SFM MCMC estimation
M = 1000 # Number of MCMC iterations 
Jmax = 4 # Maximum number of mixture components

# Estimation with SFM MCMC
sfm_mcmc = sfm_mcmc_spmix(y=y,Jmax=Jmax, M=M)

# Generating plots

# Proportion of draws burned in
S = 0.5

plots_mcmc(sfm_mcmc, S=S)

# Example with DNA data =====================================================
\donttest{
y = d4z4
M = 5000 # Number of MCMC iterations 
Jmax = 10 # Maximum number of mixture components

# Estimation with SFM MCMC
sfm_mcmc = sfm_mcmc_spmix(y=y,Jmax=Jmax, M=M)

# Generating plots

# Proportion of draws burned in
S = 0.5

plots_mcmc(sfm_mcmc, S=S)
}
}
