% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeKLDs.R
\name{ComputeKLDs}
\alias{ComputeKLDs}
\title{Compute signed and symmetric Kullback-Leibler divergence}
\usage{
ComputeKLDs(tree, var0, vars, seq, pbar = TRUE)
}
\arguments{
\item{tree}{a \code{clustertree} object}

\item{var0}{the variable to have evidence absrobed}

\item{vars}{the variables to have divergence computed}

\item{seq}{a \code{vector} of numeric values as the evidences}

\item{pbar}{\code{logical(1)} whether to show progress bar}
}
\value{
a \code{data.frame} of the divergence
}
\description{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence
}
\details{
Compute signed and symmetric Kullback-Leibler divergence of variables over a spectrum of evidence.
The signed and symmetric Kullback-Leibler divergence is also known as Jeffery's signed information (JSI) for
continuous variables.
}
\examples{
data(toytree)
klds <- ComputeKLDs(tree=toytree, var0="F", 
                    vars=c("A", "B", "C", "D", "E", "H", "G", "J"), 
                    seq=seq(-3,3,0.2))
head(klds)
}
\author{
Han Yu
}

