% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F2_SummaryMarginal.R
\name{SummaryMarginals}
\alias{SummaryMarginals}
\title{Summary a continuous marginal distribution}
\usage{
SummaryMarginals(marginals)
}
\arguments{
\item{marginals}{the marginal distributions obtained from \code{\link{Marginals}} function}
}
\value{
a \code{data.frame} object containing information about the marginal distributions for continuous variables. 
The marginal distributions of continous variables in a CG-BN model are mixtures of Gaussian distributions. 
Therefore, besides the mean and standard deviation, the object has an additional column to specify the number of Gaussian
mixtures.

\describe{
 \item{\code{mean}}{the mean value of a Gaussian distribution.}
 \item{\code{sd}}{the standard deviation of a Gaussian distribution.}
 \item{\code{n}}{the number of Gaussian distributions in the mixture.}
}
}
\description{
This function summary the marginal distributions of continuous variables by outputing the
mean, standard deviation, and number of subpopulations
}
\examples{

data(liver)
cst <- ClusterTreeCompile(dag=liver$dag, node.class=liver$node.class)
models <- LocalModelCompile(data=liver$data, dag=liver$dag, node.class=liver$node.class)
tree.init <- ElimTreeInitialize(tree=cst$tree.graph, 
                                dag=cst$dag, 
                                model=models, 
                                node.sets=cst$cluster.sets, 
                                node.class=cst$node.class)
tree.init.p <- PropagateDBN(tree.init)
marg <- Marginals(tree.init.p, c("HDL", "Ppap2a", "Neu1"))
SummaryMarginals(marginals=marg)

}
\seealso{
\code{\link{Marginals}}
}
