% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_Ord_Design_PO.R
\name{ss_po}
\alias{ss_po}
\title{Determine the sample size for Bayesian two-stage trial design
of ordinal endpoints with proportional odds assumption}
\usage{
ss_po(or_alt, pro_ctr, alpha, power, nmax, ntrial, method)
}
\arguments{
\item{or_alt}{effect size to be detected (under H_1)
in terms of odds ratio}

\item{pro_ctr}{distribution of clinical categories for the
control group}

\item{alpha}{the desirable type I error rate to be controlled}

\item{power}{the desirable power to be achieved}

\item{nmax}{the maximum sample size for searching to get the desirable power}

\item{ntrial}{the number of simulated trials}

\item{method}{whether the statistical test for interim/final analysis is Bayesian or
Frequentist. method = "Frequentist" for Frequentist approach; method = "Bayesian"
for Bayesian approach}
}
\value{
ss_po() returns recommended sample size for each of
two groups for the interim and final stages, by assuming 1:1 equal
randomization for the two groups at each stage; and the corresponding power.
}
\description{
Obtain estimated sample size based on user-specified type I
error, power and effect size defined by the odds ratio between
the treatment and control groups, under the proportional
odds (PO) assumption.
}
\details{
Grid search of sample size is used for guarantee a desirable type I error rate.
  The upper limitation is 200, and lower limitation default is sample size 50
  for the control and treatment groups at each stage. Default increment of the
  sequence is 50.

  For the parameter estimation section, we have two options, and can be selected using
  the method argument.Two following options are available: (i) method = "Frequentist",
  (ii) method = "Bayesian". If method = "Frequentist", parameters are estimated via package
  ordinal, which is based on frequentist method, while method = "Bayesian", parameters are
  estimated through Bayesian model.

  Please note, in our example, argument ntrial =  5 is for the time saving purpose.
}
\examples{
ss_po(or_alt = 1.5, pro_ctr = c(0.58,0.05,0.17,0.03,0.04,0.13), alpha = 0.05,
      power = 0.8, nmax = 100, ntrial = 5, method ="Frequentist")

}
