% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.f.test}
\alias{BF10.f.test}
\title{Bayes factor for a Bayesian F-test}
\usage{
BF10.f.test(fval, df1, df2, dff, rscale, f_m, model, e = NULL)
}
\arguments{
\item{fval}{Observed F-value from the F-test.}

\item{df1}{Degrees of freedom for the numerator of the F-test.}

\item{df2}{Degrees of freedom for the denominator of the F-test.}

\item{dff}{Degrees of freedom for the analysis prior under the alternative hypothesis (if applicable).}

\item{rscale}{Scaling parameter for the analysis effect size prior.}

\item{f_m}{Cohen's f effect size parameter for the analysis prior.}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: effect size prior (\code{"effectsize"}) or Moment prior (\code{"Moment"}).}

\item{e}{Optional numeric vector specifying bounds for an interval null; used if interval BF is calculated.}
}
\value{
The Bayes factor (BF10) for the F-test.
}
\description{
Calculate the Bayes factor (BF10) for an F-test, either against a point null or an interval null hypothesis.
}
\examples{
BF10.f.test(
  fval = 4.5,
  df1 = 2,
  df2 = 12,
  dff = 12,
  rscale = 0.707,
  f_m = .1,
  model = "effectsize"
)
}
