\name{theta.HB}
\alias{theta.HB}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Rao-Blackwell Estimators in Area-Level models  
%%  ~~function to do ... ~~
}
\description{This function provides Rao-Blackwell estimators for specific area-level models based on MCMC
draws obtained by the \code{BayesSAE} function. Rao-Blackwellization for unmatched models is not available 
at present. See \code{\link{BayesSAE}}. 
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
theta.HB(result, samp, link, subset)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{result}{MCMC draws obtained by \code{\link{BayesSAE}} function. 
%%     ~~Describe \code{result} here~~
}
  \item{samp}{list generate by \code{\link{samp.model}} function. 
%%     ~~Describe \code{samp} here~~
}
  \item{link}{list generated by \code{\link{link.model}} function. 
%%     ~~Describe \code{link} here~~
}
  \item{subset}{vector specifying subset of MCMC draws used to obtain Rao-Blackwell estimators. 
  If omitted, all draws are utilized. See Details.
%%     ~~Describe \code{subset} here~~
}
}
\details{Usually a "burn-in" process is used to cast some iterations at the beginning of an MCMC run 
(Gelman \emph{et. al} (2006)). For example, if the total number of iterations is 5000. You could specify 
\code{subset = 3001:5000} so as to use the last 2000 iterations to get Rao-Blackwell estimators.   
%%  ~~ If necessary, more details than the description above ~~
}
\value{a vector of length the same as number of domains provides Rao-Blackwell estimators for each area. 
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
Gelman, A. and Carlin, J. B. and Stern, H. S. and Rubin, D. B. (2006). \emph{ Bayesian Data Analysis,} 
CRC Press Company.
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
Chengchun Shi
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{BayesSAE}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
#load data set
data(SAIPE)

#construct the sampling model
samp <- samp.model(y = SACPR, vardir = Vardir, data = SAIPE, innov = "t", 
   	df = rep(50, length(SAIPE$SACPR)))

#construct the linking model
link <- link.model(~SNAPR+CenPR+CPER, data = SAIPE)

#get initial values
MCMCstart <- list(theta = runif(51), beta = runif(4), lambda = runif(1))

#specify priors
Sqsigmavprior <- list(a0 = 0.1^6, b0 = 0.1^6)
Sqsigmaprior <- list(ai = rep(0.1^6, 51), bi = rep(0.1^6, 51))
prior <- list(betatype = "non_in", Sqsigmavtype = "inv_gamma", Sqsigmavprior = Sqsigmavprior, 
   	Sqsigmaprior = Sqsigmaprior)

#obtain MCMC draws
result <- BayesSAE(samp, link, MCMCstart, prior, 5000)

#obtain Rao-Blackwell estimators
theta_HB <- theta.HB(result, samp, link, 3001:5000)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Rao-Blackwellization }
