% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_latent_distribution.R
\name{draw_latent_noise_distribution}
\alias{draw_latent_noise_distribution}
\title{Visualization of the Latent Gaussian for Hit rates}
\usage{
draw_latent_noise_distribution(StanS4class, dark_theme = TRUE, dig = 3,
  mesh = 1000, new.imaging.device = TRUE, hit.rate = FALSE,
  false.alarm.rate = TRUE, both.hit.and.false.rate = FALSE,
  density = 22, color = TRUE, mathmatical.symbols = TRUE)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}  that can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{dark_theme}{TRUE or FALSE}

\item{dig}{Digit for print of the outputs in the R console.}

\item{mesh}{Mesh for painting the area}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{hit.rate}{whether draws it. Default is \code{TRUE}.}

\item{false.alarm.rate}{whether draws it. Default is \code{TRUE}.}

\item{both.hit.and.false.rate}{whether draws it. Default is \code{TRUE}.}

\item{density}{A natural number, indicating the density of shading lines, in lines per inch.}

\item{color}{A color region is selected from black and white only. For more colors, put \code{FALSE}. For publication, the mono color is allowed in many case, so the author made this for such publication.}

\item{mathmatical.symbols}{A logical, whether legend is in plot.
 @seealso
\code{\link{draw_latent_noise_distribution}()}
Note that the difference of \code{\link{draw_latent_noise_distribution}()} and
  \code{draw_latent_signal_distribution()} is that the lator use the standard Gaussian for the reference distribution and
  former uses the \eqn{d \log \Phi()} for the reference distribution.

  So, the  old version \code{draw_latent_signal_distribution()}  is also important and I like this old version also.
  Anyway who read this, I think my package size is very large,....ha,,,,I have to reduce it,....but how?}
}
\value{
Information of Latent Gaussians, such as mean and S.D. of the signal distributions and thresholds.
}
\description{
Our FROC model use a latent Gaussian random variable to determine hit rates.
That is each hit rate is defined as follows;

\deqn{ p_5(z_1,...z_C; \mu, \sigma) = \int_{z5}^{\infty} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_4(z_1,...z_C; \mu, \sigma) = \int_{z4}^{5} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_3(z_1,...z_C; \mu, \sigma) = \int_{z3}^{4} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_2(z_1,...z_C; \mu, \sigma) = \int_{z2}^{3} Gaussian(z|\mu,\sigma)dz}
\deqn{ p_1(z_1,...z_C; \mu, \sigma) = \int_{z1}^{2} Gaussian(z|\mu,\sigma)dz}

 For example, in the following data, the number of hit data with confidence level 5 \strong{41} which
 is considered as an sample from the Binomial distribution of hit rate
   \eqn{p_5(z_1,...z_C; \mu, \sigma) = \int_{z5}^{\infty} Gaussian(z|\mu,\sigma)dz}


   with
 Bernoulli trial number is NL=142.

 So, this Gaussian distribution determines hit rate, and this function \code{draw_latent_noise_distribution()} plot
 this Gaussian distribution \eqn{ Gaussian(z|\mu,\sigma)}.
 But reference distribution is not the standard Gaussian but \eqn{d \log \Phi} which determines the
 False alarm rate in the above manner.
 The author thinks the standard Gaussian is more comfortable to compare or confirm the shape of  \eqn{ Gaussian(z|\mu,\sigma)} and
 thus, the author implement it in the \code{\link{draw_latent_signal_distribution}()},



\strong{\emph{ Example data:}}

 \emph{            A single reader and single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab  5 \tab 1 \tab 41 \cr
 \emph{probably} present   \tab  4 \tab 2 \tab 22 \cr
 equivocal          \tab  3 \tab 5 \tab 14  \cr
 subtle    \tab  2 \tab 11 \tab 8  \cr
 \emph{very} subtle       \tab  1 \tab 13 \tab 1  \cr
 }

---------------------------------------------------------------------------------------------------


*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP
}
\examples{
\donttest{
#----------------------------------------------------------------------------------------
#   Shap of signal distribution is strongly affected by the AUC, so
#   the author shows how it changes according to the two data examples.
#   In the high AUC case, the Signal Gaussain will be low variance and
#   in the low AUC case, the variance will desperse.  2019 August 4
#----------------------------------------------------------------------------------------

#            ----- High AUC case --------

     viewdata(dataList.High)

     fit.High <- fit_Bayesian_FROC(dataList.High,ite=111)

     draw_latent_signal_distribution(fit.High)




#            ----- Low AUC case --------

     viewdata(dataList.Low)

     fit.Low <- fit_Bayesian_FROC(dataList.Low)

     draw_latent_signal_distribution(fit.Low)

}# dottest
}
\seealso{
\code{\link{draw_latent_signal_distribution}()}
}
\author{
Issei Tsunoda
}
