% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCalCurve.R
\name{createCalCurve}
\alias{createCalCurve}
\title{Create a new calibration curve}
\usage{
createCalCurve(
  name,
  calAges,
  uncalAges,
  oneSigma = rep(0, length(calAges)),
  pathToCalCurves = getwd(),
  createFile = TRUE
)
}
\arguments{
\item{name}{The name of the new calibration curve}

\item{calAges}{A vector of the calendar/calibrated ages in years before present}

\item{uncalAges}{A vector of values of uncalibrated ages in appropriate units (e.g. 14C years BP)}

\item{oneSigma}{The one sigma (one standard deviation) values in uncalibrated units. If left blank it assumes these are all zero}

\item{pathToCalCurves}{The path to the calibration curves. Will write by default to the working directory}

\item{createFile}{whether to write out the new file or not. Only turned off for testing purposes}
}
\description{
A function for creating a new calibration curve not already available in Bchron
}
\details{
All calibration curves are stored by Bchron in the standard R gzipped text format. You can find the location of the calibration curves by typing \code{system.file('data',package='Bchron')}. Any created calibration curve will be converted to this format. However R packages are not allowed to write to this directory so it is up to the user to put the resulting calibration curve file in the appropriate directory. It can then be used as in the examples below. However note that re-installing Bchron will likely over-write previously created calibration curves so you should make sure to store the code used to create it. As a short-cut to copying it by hand you can instead use the \code{file.copy} command in the example below.
}
\examples{
\dontrun{
# Load in the calibration curve with:
intcal09 = read.table(system.file('extdata/intcal09.14c', package = 'Bchron'), sep=',')
# Run createCalCurve
createCalCurve(name='intcal09',calAges=intcal09[,1], 
uncalAges=intcal09[,2],oneSigma=intcal09[,3])

# Copy the file to the right place
file.copy(from = 'intcal09.rda',
           to = system.file('data',package='Bchron'),
                            overwrite = TRUE) # Only need this if you've run it more than once

# Calibrate the ages under two calibration curves
age_09 = BchronCalibrate(ages=15500, ageSds=150,
                          calCurves = 'intcal09',ids='My Date', 
                          pathToCalCurves = getwd())
age_13 = BchronCalibrate(ages=15500,ageSds=150,calCurves = 'intcal13')

# Finally plot the difference
library(ggplot2)
plot(age_09) + 
geom_line(data = as.data.frame(age_13$Date1), 
         aes(x = ageGrid, y = densities), col = 'red') + 
     ggtitle('Intcal09 vs Intcal13')
}
}
\seealso{
\code{\link{BchronCalibrate}}
}
