/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.parallel;

import dr.inference.parallel.ServiceRequest;
import mpi.MPI;
import mpi.Status;

public class MPIServices {
    public static void requestTermination(int n) {
        int[] nArray = new int[]{ServiceRequest.terminateProcess.getId()};
        MPI.COMM_WORLD.Send((Object)nArray, 0, 1, MPI.INT, n, 10);
    }

    public static void requestLikelihood(int n) {
        int[] nArray = new int[]{ServiceRequest.calculateLikeliood.getId()};
        MPI.COMM_WORLD.Send((Object)nArray, 0, 1, MPI.INT, n, 10);
    }

    public static ServiceRequest getRequest(int n) {
        int[] nArray = new int[1];
        Status status = MPI.COMM_WORLD.Recv((Object)nArray, 0, 1, MPI.INT, n, 10);
        return ServiceRequest.getByID(nArray[0]);
    }

    public static void sendDouble(double d, int n) {
        double[] dArray = new double[]{d};
        MPI.COMM_WORLD.Send((Object)dArray, 0, 1, MPI.DOUBLE, n, 10);
    }

    public static void sendDoubleArray(double[] dArray, int n) {
        MPI.COMM_WORLD.Send((Object)dArray, 0, dArray.length, MPI.DOUBLE, n, 10);
    }

    public static void sendDoubleArray(Double[] doubleArray, int n) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        MPIServices.sendDoubleArray(dArray, n);
    }

    public static void sendIntArray(int[] nArray, int n) {
        MPI.COMM_WORLD.Send((Object)nArray, 0, nArray.length, MPI.INT, n, 10);
    }

    public static void sendInt(int n, int n2) {
        int[] nArray = new int[]{n};
        MPI.COMM_WORLD.Send((Object)nArray, 0, 1, MPI.INT, n2, 10);
    }

    public static int receiveInt(int n) {
        int[] nArray = new int[1];
        Status status = MPI.COMM_WORLD.Recv((Object)nArray, 0, 1, MPI.INT, n, 10);
        return nArray[0];
    }

    public static double receiveDouble(int n) {
        double[] dArray = new double[1];
        Status status = MPI.COMM_WORLD.Recv((Object)dArray, 0, 1, MPI.DOUBLE, n, 10);
        return dArray[0];
    }

    public static double[] receiveDoubleArray(int n, int n2) {
        double[] dArray = new double[n2];
        Status status = MPI.COMM_WORLD.Recv((Object)dArray, 0, n2, MPI.DOUBLE, n, 10);
        return dArray;
    }

    public static int[] receiveIntArray(int n, int n2) {
        int[] nArray = new int[n2];
        Status status = MPI.COMM_WORLD.Recv((Object)nArray, 0, n2, MPI.INT, n, 10);
        return nArray;
    }
}

