/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.clock;

import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.math.distributions.InverseGaussianDistribution;
import dr.math.distributions.LogNormalDistribution;
import dr.math.distributions.NormalDistribution;
import dr.oldevomodel.clock.RateEvolutionLikelihood;

public class ACLikelihood
extends RateEvolutionLikelihood {
    public static final String LOGNORMAL = "logNormal";
    public static final String NORMAL = "normal";
    public static final String INVERSEGAUSSIAN = "inverseGaussian";
    private Parameter variance;
    String distribution;

    public ACLikelihood(TreeModel treeModel, Parameter parameter, Parameter parameter2, Parameter parameter3, boolean bl, String string) {
        super(string, treeModel, parameter, parameter3, bl);
        this.variance = parameter2;
        this.distribution = string;
        this.addVariable(parameter2);
    }

    @Override
    double branchRateChangeLogLikelihood(double d, double d2, double d3) {
        double d4 = this.variance.getParameterValue(0);
        if (!this.isEpisodic()) {
            d4 *= d3;
        }
        if (this.distribution.equals(LOGNORMAL)) {
            return LogNormalDistribution.logPdf(d2, Math.log(d) - d4 / 2.0, Math.sqrt(d4));
        }
        if (this.distribution.equals(NORMAL)) {
            return NormalDistribution.logPdf(d2, d, Math.sqrt(d4));
        }
        if (this.distribution.equals(INVERSEGAUSSIAN)) {
            double d5 = d * d * d / d4;
            return InverseGaussianDistribution.logPdf(d2, d, d5);
        }
        throw new RuntimeException("Parameter for distribution is not recognised");
    }

    @Override
    double branchRateSample(double d, double d2) {
        double d3 = this.variance.getParameterValue(0);
        if (!this.isEpisodic()) {
            d3 *= d2;
        }
        if (this.distribution.equals(LOGNORMAL)) {
            double d4 = Math.log(d);
            return Math.exp(MathUtils.nextGaussian() * Math.sqrt(d3) + d4 - d3 / 2.0);
        }
        if (this.distribution.equals(NORMAL)) {
            return MathUtils.nextGaussian() * Math.sqrt(d3) + d;
        }
        double d5 = d * d * d / d3;
        return MathUtils.nextInverseGaussian(d, d5);
    }
}

