/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class TwoEpochDemographic
extends DemographicFunction.Abstract {
    private DemographicFunction epoch1;
    private DemographicFunction epoch2;
    private double transitionTime;

    public TwoEpochDemographic(DemographicFunction demographicFunction, DemographicFunction demographicFunction2, Units.Type type) {
        super(type);
        this.epoch1 = demographicFunction;
        this.epoch2 = demographicFunction2;
    }

    public final double getTransitionTime() {
        return this.transitionTime;
    }

    public final void setTransitionTime(double d) {
        if (d < 0.0 || d > Double.MAX_VALUE) {
            throw new IllegalArgumentException("transition time out of bounds.");
        }
        this.transitionTime = d;
    }

    public final DemographicFunction getFirstEpochDemography() {
        return this.epoch1;
    }

    public final DemographicFunction getSecondEpochDemography() {
        return this.epoch2;
    }

    @Override
    public final double getDemographic(double d) {
        if (d < this.transitionTime) {
            return this.epoch1.getDemographic(d);
        }
        return this.epoch2.getDemographic(d - this.transitionTime);
    }

    @Override
    public final double getIntensity(double d) {
        if (d < this.transitionTime) {
            return this.epoch1.getIntensity(d);
        }
        return this.epoch1.getIntensity(this.transitionTime) + this.epoch2.getIntensity(d - this.transitionTime);
    }

    @Override
    public final double getIntegral(double d, double d2) {
        if (d < this.transitionTime) {
            if (d2 < this.transitionTime) {
                return this.epoch1.getIntegral(d, d2);
            }
            return this.epoch1.getIntegral(d, this.transitionTime) + this.epoch2.getIntegral(0.0, d2 - this.transitionTime);
        }
        return this.epoch2.getIntegral(d - this.transitionTime, d2 - this.transitionTime);
    }

    @Override
    public final double getInverseIntensity(double d) {
        double d2 = this.epoch1.getInverseIntensity(d);
        if (d2 < this.transitionTime) {
            return d2;
        }
        return this.transitionTime + this.epoch2.getInverseIntensity(d -= this.epoch1.getIntensity(this.transitionTime));
    }

    @Override
    public int getNumArguments() {
        return this.epoch1.getNumArguments() + this.epoch2.getNumArguments() + 1;
    }

    @Override
    public final String getArgumentName(int n) {
        if (n < this.epoch1.getNumArguments()) {
            return this.epoch1.getArgumentName(n);
        }
        if ((n -= this.epoch1.getNumArguments()) < this.epoch2.getNumArguments()) {
            return this.epoch2.getArgumentName(n);
        }
        if ((n -= this.epoch2.getNumArguments()) == 0) {
            return "transitionTime";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final double getArgument(int n) {
        if (n < this.epoch1.getNumArguments()) {
            return this.epoch1.getArgument(n);
        }
        if ((n -= this.epoch1.getNumArguments()) < this.epoch2.getNumArguments()) {
            return this.epoch2.getArgument(n);
        }
        if ((n -= this.epoch2.getNumArguments()) == 0) {
            return this.transitionTime;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final void setArgument(int n, double d) {
        if (n < this.epoch1.getNumArguments()) {
            this.epoch1.setArgument(n, d);
        }
        if ((n -= this.epoch1.getNumArguments()) < this.epoch2.getNumArguments()) {
            this.epoch2.setArgument(n, d);
        }
        if ((n -= this.epoch2.getNumArguments()) == 0) {
            this.transitionTime = d;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final double getLowerBound(int n) {
        if (n < this.epoch1.getNumArguments()) {
            return this.epoch1.getLowerBound(n);
        }
        if ((n -= this.epoch1.getNumArguments()) < this.epoch2.getNumArguments()) {
            return this.epoch2.getLowerBound(n);
        }
        if ((n -= this.epoch2.getNumArguments()) == 0) {
            return 0.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final double getUpperBound(int n) {
        if (n < this.epoch1.getNumArguments()) {
            return this.epoch1.getUpperBound(n);
        }
        if ((n -= this.epoch1.getNumArguments()) < this.epoch2.getNumArguments()) {
            return this.epoch2.getUpperBound(n);
        }
        if ((n -= this.epoch2.getNumArguments()) == 0) {
            return Double.MAX_VALUE;
        }
        throw new IllegalArgumentException();
    }

    public final DemographicFunction getCopy() {
        TwoEpochDemographic twoEpochDemographic = new TwoEpochDemographic(this.epoch1, this.epoch2, this.getUnits());
        twoEpochDemographic.setTransitionTime(this.transitionTime);
        return twoEpochDemographic;
    }
}

