/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;

public class PairedDataType
extends DataType {
    public static final String DESCRIPTION = "pairedDataType";
    public static final PairedDataType PAIRED_NUCLEOTIDES = new PairedDataType(Nucleotides.INSTANCE);
    public static final PairedDataType PAIRED_AMINO_ACIDS = new PairedDataType(AminoAcids.INSTANCE);
    public static final PairedDataType PAIRED_CODONS = new PairedDataType(Codons.UNIVERSAL);
    private DataType baseDataType;

    public PairedDataType(DataType dataType) {
        this.baseDataType = dataType;
        this.stateCount = dataType.getStateCount() * dataType.getStateCount();
        this.ambiguousStateCount = this.stateCount + 2;
    }

    public final int getState(int n, int n2) {
        if (this.baseDataType.isAmbiguousState(n) || this.baseDataType.isAmbiguousState(n2)) {
            return this.getUnknownState();
        }
        return n * this.baseDataType.getStateCount() + n2;
    }

    public final int getState(char c, char c2) {
        return this.getState(this.baseDataType.getState(c), this.baseDataType.getState(c2));
    }

    public final int getFirstState(int n) {
        return n / this.baseDataType.getStateCount();
    }

    public final int getSecondState(int n) {
        return n % this.baseDataType.getStateCount();
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public final int getState(char c) {
        throw new IllegalArgumentException("Paired datatype cannot be expressed as char");
    }

    @Override
    public int getUnknownState() {
        return this.stateCount;
    }

    @Override
    public int getGapState() {
        return this.stateCount + 1;
    }

    @Override
    public final char getChar(int n) {
        throw new IllegalArgumentException("Paired datatype cannot be expressed as char");
    }

    @Override
    public final String getTriplet(int n) {
        throw new IllegalArgumentException("Paired datatype cannot be expressed as triplets");
    }

    public final int[] getTripletStates(int n) {
        throw new IllegalArgumentException("Paired datatype cannot be expressed as triplets");
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return -1;
    }
}

