/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.util.Units;
import dr.evomodel.coalescent.PopulationSizeFunction;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;

public abstract class PopulationSizeModel
extends AbstractModel
implements Units {
    private final Parameter logN0Parameter;
    private Units.Type units;

    public PopulationSizeModel(String string, Parameter parameter, Units.Type type) {
        super(string);
        if (parameter != null) {
            this.logN0Parameter = parameter;
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        } else {
            this.logN0Parameter = new Parameter.Default(1);
        }
        this.addVariable(this.logN0Parameter);
        this.addStatistic(new N0Statistic());
        this.setUnits(type);
    }

    public abstract PopulationSizeFunction getPopulationSizeFunction();

    final void setLogN0(double d) {
        this.logN0Parameter.setParameterValueQuietly(0, d);
    }

    public final double getN0() {
        return Math.exp(this.logN0Parameter.getParameterValue(0));
    }

    public final double getLogN0() {
        return this.logN0Parameter.getParameterValue(0);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged();
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    public class N0Statistic
    extends Statistic.Abstract {
        public N0Statistic() {
            super("N0");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return PopulationSizeModel.this.getN0();
        }
    }
}

