/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SubtreeSlideOperator
extends AbstractAdaptableTreeOperator {
    private static final boolean DEBUG = false;
    private TreeModel tree = null;
    private double size = 1.0;
    private boolean gaussian = false;
    private final boolean swapInRandomRate;
    private final boolean swapInRandomTrait;
    private final boolean scaledDirichletBranches;
    private AdaptationMode mode = AdaptationMode.DEFAULT;
    private final double targetAcceptance;

    public SubtreeSlideOperator(TreeModel treeModel, double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        this.tree = treeModel;
        this.setWeight(d);
        if (d2 == 0.0) {
            double d4 = 0.0;
            for (int i = 0; i < treeModel.getNodeCount(); ++i) {
                d4 += treeModel.getBranchLength(treeModel.getNode(i));
            }
            d2 = d4 / (double)(2 * treeModel.getNodeCount());
        }
        this.size = d2;
        this.gaussian = bl;
        this.swapInRandomRate = bl2;
        this.swapInRandomTrait = bl3;
        this.scaledDirichletBranches = bl4;
        this.mode = adaptationMode;
        this.targetAcceptance = d3;
    }

    @Override
    public double doOperation() {
        double d;
        Serializable serializable;
        NodeRef nodeRef;
        NodeRef nodeRef2 = this.tree.getRoot();
        double d2 = this.tree.getNodeHeight(nodeRef2);
        while (nodeRef2 == (nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount())))) {
        }
        NodeRef nodeRef3 = this.tree.getParent(nodeRef);
        NodeRef nodeRef4 = this.getOtherChild(this.tree, nodeRef3, nodeRef);
        NodeRef nodeRef5 = this.tree.getParent(nodeRef3);
        double d3 = this.getDelta();
        double d4 = this.tree.getNodeHeight(nodeRef3);
        double d5 = d4 + d3;
        if (d3 > 0.0) {
            if (nodeRef5 != null && this.tree.getNodeHeight(nodeRef5) < d5) {
                serializable = nodeRef5;
                NodeRef nodeRef6 = nodeRef3;
                while (this.tree.getNodeHeight((NodeRef)serializable) < d5) {
                    nodeRef6 = serializable;
                    if ((serializable = this.tree.getParent((NodeRef)serializable)) != null) continue;
                }
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef6)) {
                    this.tree.removeChild(nodeRef3, nodeRef4);
                    this.tree.removeChild(nodeRef5, nodeRef3);
                    this.tree.addChild(nodeRef3, nodeRef6);
                    this.tree.addChild(nodeRef5, nodeRef4);
                    this.tree.setRoot(nodeRef3);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef6, nodeRef3);
                    }
                    if (this.tree.hasRates()) {
                        double d6 = this.tree.getNodeRate(nodeRef6);
                        this.tree.setNodeRate(nodeRef6, this.tree.getNodeRate(nodeRef3));
                        this.tree.setNodeRate(nodeRef3, d6);
                    }
                } else {
                    this.tree.removeChild(nodeRef3, nodeRef4);
                    this.tree.removeChild(nodeRef5, nodeRef3);
                    this.tree.removeChild((NodeRef)serializable, nodeRef6);
                    this.tree.addChild(nodeRef3, nodeRef6);
                    this.tree.addChild(nodeRef5, nodeRef4);
                    this.tree.addChild((NodeRef)serializable, nodeRef3);
                }
                this.tree.setNodeHeight(nodeRef3, d5);
                this.tree.endTreeEdit();
                int n = this.intersectingEdges(this.tree, nodeRef6, d4, null);
                d = -Math.log(n);
            } else {
                this.tree.setNodeHeight(nodeRef3, d5);
                d = 0.0;
            }
        } else {
            if (this.tree.getNodeHeight(nodeRef) > d5) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.tree.getNodeHeight(nodeRef4) > d5) {
                serializable = new ArrayList();
                int n = this.intersectingEdges(this.tree, nodeRef4, d5, (List<NodeRef>)((Object)serializable));
                if (serializable.size() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n2 = MathUtils.nextInt(serializable.size());
                NodeRef nodeRef7 = (NodeRef)serializable.get(n2);
                NodeRef nodeRef8 = this.tree.getParent(nodeRef7);
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef3)) {
                    this.tree.removeChild(nodeRef3, nodeRef4);
                    this.tree.removeChild(nodeRef8, nodeRef7);
                    this.tree.addChild(nodeRef3, nodeRef7);
                    this.tree.addChild(nodeRef8, nodeRef3);
                    this.tree.setRoot(nodeRef4);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef3, nodeRef4);
                    }
                    if (this.tree.hasRates()) {
                        double d7 = this.tree.getNodeRate(nodeRef3);
                        this.tree.setNodeRate(nodeRef3, this.tree.getNodeRate(nodeRef4));
                        this.tree.setNodeRate(nodeRef4, d7);
                    }
                } else {
                    this.tree.removeChild(nodeRef3, nodeRef4);
                    this.tree.removeChild(nodeRef5, nodeRef3);
                    this.tree.removeChild(nodeRef8, nodeRef7);
                    this.tree.addChild(nodeRef3, nodeRef7);
                    this.tree.addChild(nodeRef5, nodeRef4);
                    this.tree.addChild(nodeRef8, nodeRef3);
                }
                this.tree.setNodeHeight(nodeRef3, d5);
                this.tree.endTreeEdit();
                d = Math.log(n);
            } else {
                this.tree.setNodeHeight(nodeRef3, d5);
                d = 0.0;
            }
        }
        if (this.swapInRandomRate && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            double d8 = this.tree.getNodeRate(nodeRef);
            this.tree.setNodeRate(nodeRef, this.tree.getNodeRate((NodeRef)serializable));
            this.tree.setNodeRate((NodeRef)serializable, d8);
        }
        if (this.swapInRandomTrait && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            this.tree.swapAllTraits(nodeRef, (NodeRef)serializable);
        }
        if (this.scaledDirichletBranches && d2 != this.tree.getNodeHeight(this.tree.getRoot())) {
            throw new UnsupportedOperationException("Temporarily disabled.");
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private int intersectingEdges(Tree tree, NodeRef nodeRef, double d, List<NodeRef> list) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (tree.getNodeHeight(nodeRef) < d) {
            if (list != null) {
                list.add(nodeRef);
            }
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += this.intersectingEdges(tree, tree.getChild(nodeRef, i), d, list);
        }
        return n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return "subtreeSlide(" + this.tree.getId() + ")";
    }
}

