/*
 * Decompiled with CFR 0.152.
 */
package dr.app.checkpoint;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.Tree;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class DebugTreeImporter {
    private static final boolean DEBUG = true;

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            throw new RuntimeException("Incorrect number of arguments.");
        }
        try {
            int n;
            FileReader fileReader = new FileReader(stringArray[2]);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.readLine();
            NewickImporter newickImporter = new NewickImporter(string);
            Tree tree = newickImporter.importNextTree();
            System.out.println("root height: " + tree.getNodeHeight(tree.getRoot()));
            FileReader fileReader2 = new FileReader(stringArray[0]);
            BufferedReader bufferedReader2 = new BufferedReader(fileReader2);
            FileWriter fileWriter = new FileWriter(stringArray[3]);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            String string2 = bufferedReader2.readLine();
            String[] stringArray2 = string2.split("\t");
            while (!stringArray2[0].equals("treeModel.rootHeight")) {
                System.out.println(string2);
                bufferedWriter.write(string2 + "\n");
                string2 = bufferedReader2.readLine();
                stringArray2 = string2.split("\t");
            }
            stringArray2[2] = Double.toString(tree.getNodeHeight(tree.getRoot()));
            for (n = 0; n < stringArray2.length; ++n) {
                bufferedWriter.write(stringArray2[n] + "\t");
            }
            bufferedWriter.write("\n");
            n = tree.getNodeCount();
            System.out.println(n + " nodes found in tree.");
            for (int i = 0; i < n - 1; ++i) {
                System.out.println(tree.getNode(i).getNumber() + "\t" + tree.getNodeHeight(tree.getNode(i)));
                bufferedWriter.write(tree.getNode(i).getNumber() + "\t1\t" + tree.getNodeHeight(tree.getNode(i)) + "\n");
            }
            string2 = bufferedReader2.readLine();
            System.out.println(string2);
            stringArray2 = string2.split("\t");
            while (DebugTreeImporter.isInteger(stringArray2[0])) {
                string2 = bufferedReader2.readLine();
                stringArray2 = string2.split("\t");
            }
            while (!stringArray2[0].equals("treeModel")) {
                bufferedWriter.write(string2 + "\n");
                string2 = bufferedReader2.readLine();
                System.out.println(string2);
                stringArray2 = string2.split("\t");
            }
            bufferedWriter.write(stringArray2[0] + "\t" + string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Tree file not found.");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read file: " + iOException.getMessage());
        }
        catch (Importer.ImportException importException) {
            throw new RuntimeException("Unable to import tree: " + importException.getMessage());
        }
    }
}

