/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.util.Units;
import dr.math.Binomial;
import dr.math.MathUtils;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.RombergIntegrator;

public interface DemographicFunction
extends UnivariateRealFunction,
Units {
    public double getDemographic(double var1);

    public double getLogDemographic(double var1);

    public double getIntensity(double var1);

    public double getInverseIntensity(double var1);

    public double getIntegral(double var1, double var3);

    public int getNumArguments();

    public String getArgumentName(int var1);

    public double getArgument(int var1);

    public void setArgument(int var1, double var2);

    public double getLowerBound(int var1);

    public double getUpperBound(int var1);

    public double getThreshold();

    public double getIntensityGradient(double var1);

    public double getLogDemographicGradient(double var1);

    public static class Utils {
        private static double getInterval(double d, DemographicFunction demographicFunction, int n, double d2) {
            double d3 = demographicFunction.getIntensity(d2);
            double d4 = -Math.log(d) / Binomial.choose2(n) + d3;
            return demographicFunction.getInverseIntensity(d4) - d2;
        }

        private static double getInterval(double d, DemographicFunction demographicFunction, int n, double d2, double d3) {
            if (d2 > d3) {
                throw new IllegalArgumentException("Given maximum height is smaller than given final coalescent time");
            }
            double d4 = demographicFunction.getIntegral(d2, d3);
            double d5 = 1.0 - Math.exp(-Binomial.choose2(n) * d4);
            double d6 = demographicFunction.getIntensity(d2);
            double d7 = -Math.log(1.0 - d * d5) / Binomial.choose2(n) + d6;
            return demographicFunction.getInverseIntensity(d7) - d2;
        }

        public static double getSimulatedInterval(DemographicFunction demographicFunction, int n, double d) {
            double d2 = MathUtils.nextDouble();
            return Utils.getInterval(d2, demographicFunction, n, d);
        }

        public static double getSimulatedInterval(DemographicFunction demographicFunction, int n, double d, double d2) {
            double d3 = MathUtils.nextDouble();
            return Utils.getInterval(d3, demographicFunction, n, d, d2);
        }

        public static double getMedianInterval(DemographicFunction demographicFunction, int n, double d) {
            return Utils.getInterval(0.5, demographicFunction, n, d);
        }

        public static void testConsistency(DemographicFunction demographicFunction, int n, double d) {
            double d2 = d / (double)n;
            for (int i = 0; i <= n; ++i) {
                double d3 = (double)i * d2;
                double d4 = demographicFunction.getIntensity(d3);
                double d5 = demographicFunction.getInverseIntensity(d4);
                if (!(Math.abs(d3 - d5) > 1.0E-12)) continue;
                throw new RuntimeException("Demographic model not consistent! error size = " + Math.abs(d3 - d5));
            }
        }
    }

    public static abstract class Abstract
    implements DemographicFunction {
        RombergIntegrator numericalIntegrator = null;
        private Units.Type units;

        public Abstract(Units.Type type) {
            this.setUnits(type);
        }

        @Override
        public double getLogDemographic(double d) {
            return Math.log(this.getDemographic(d));
        }

        @Override
        public double getThreshold() {
            return 0.0;
        }

        @Override
        public double getIntegral(double d, double d2) {
            return this.getIntensity(d2) - this.getIntensity(d);
        }

        @Override
        public double getIntensityGradient(double d) {
            throw new RuntimeException("not yet implemented!");
        }

        @Override
        public double getLogDemographicGradient(double d) {
            throw new RuntimeException("not yet implemented!");
        }

        public double getNumericalIntegral(double d, double d2) {
            if (d > d2) {
                throw new RuntimeException("NumericalIntegration start > finish");
            }
            if (d == d2) {
                return 0.0;
            }
            if (this.numericalIntegrator == null) {
                this.numericalIntegrator = new RombergIntegrator(this);
            }
            try {
                return this.numericalIntegrator.integrate(d, d2);
            }
            catch (MaxIterationsExceededException maxIterationsExceededException) {
                throw new RuntimeException(maxIterationsExceededException);
            }
            catch (FunctionEvaluationException functionEvaluationException) {
                throw new RuntimeException(functionEvaluationException);
            }
        }

        @Override
        public double value(double d) {
            return 1.0 / this.getDemographic(d);
        }

        @Override
        public void setUnits(Units.Type type) {
            this.units = type;
        }

        @Override
        public Units.Type getUnits() {
            return this.units;
        }
    }
}

