/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.util.Attributable;
import java.util.Iterator;

public class FlexibleNode
implements NodeRef,
Attributable {
    private FlexibleNode parent = null;
    private int nodeNumber;
    private double height;
    private double length;
    private double rate;
    private Taxon taxon = null;
    private FlexibleNode[] child;
    private String id = null;
    private Attributable.AttributeHelper attributes = null;

    public FlexibleNode() {
        this.child = null;
        this.height = 0.0;
        this.rate = 1.0;
        this.nodeNumber = 0;
    }

    public FlexibleNode(Taxon taxon) {
        this.child = null;
        this.height = 0.0;
        this.rate = 1.0;
        this.nodeNumber = 0;
        this.taxon = taxon;
    }

    public FlexibleNode(FlexibleNode flexibleNode) {
        this.setHeight(flexibleNode.getHeight());
        this.setLength(flexibleNode.getLength());
        this.setRate(flexibleNode.getRate());
        this.setId(flexibleNode.getId());
        this.setNumber(flexibleNode.getNumber());
        this.setTaxon(flexibleNode.getTaxon());
        this.child = null;
        for (int i = 0; i < flexibleNode.getChildCount(); ++i) {
            this.addChild(new FlexibleNode(flexibleNode.getChild(i)));
        }
    }

    public FlexibleNode(Tree tree, NodeRef nodeRef) {
        this(tree, nodeRef, false);
    }

    public FlexibleNode(Tree tree, NodeRef nodeRef, boolean bl) {
        Iterator iterator;
        this.setHeight(tree.getNodeHeight(nodeRef));
        this.setLength(tree.getBranchLength(nodeRef));
        this.setRate(tree.getNodeRate(nodeRef));
        this.setId(tree.getTaxonId(nodeRef.getNumber()));
        this.setNumber(nodeRef.getNumber());
        this.setTaxon(tree.getNodeTaxon(nodeRef));
        this.child = null;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            this.addChild(new FlexibleNode(tree, tree.getChild(nodeRef, i), bl));
        }
        if (bl && (iterator = tree.getNodeAttributeNames(nodeRef)) != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.setAttribute(string, tree.getNodeAttribute(nodeRef, string));
            }
        }
    }

    public FlexibleNode getDeepCopy() {
        return new FlexibleNode(this);
    }

    public FlexibleNode getShallowCopy() {
        FlexibleNode flexibleNode = new FlexibleNode();
        flexibleNode.setHeight(this.getHeight());
        flexibleNode.setLength(this.getLength());
        flexibleNode.setRate(this.getRate());
        flexibleNode.setId(this.getId());
        flexibleNode.setNumber(this.getNumber());
        flexibleNode.setTaxon(this.getTaxon());
        return flexibleNode;
    }

    public final FlexibleNode getParent() {
        return this.parent;
    }

    public void setParent(FlexibleNode flexibleNode) {
        this.parent = flexibleNode;
    }

    public final double getHeight() {
        return this.height;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public final double getLength() {
        return this.length;
    }

    public final void setLength(double d) {
        this.length = d;
    }

    @Deprecated
    public final double getRate() {
        return this.rate;
    }

    @Deprecated
    public final void setRate(double d) {
        this.rate = d;
    }

    @Override
    public void setNumber(int n) {
        this.nodeNumber = n;
    }

    @Override
    public int getNumber() {
        return this.nodeNumber;
    }

    public void setTaxon(Taxon taxon) {
        this.taxon = taxon;
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public FlexibleNode getChild(int n) {
        return this.child[n];
    }

    public boolean hasChild(FlexibleNode flexibleNode) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (flexibleNode != this.child[i]) continue;
            return true;
        }
        return false;
    }

    public void addChild(FlexibleNode flexibleNode) {
        this.insertChild(flexibleNode, this.getChildCount());
    }

    public void insertChild(FlexibleNode flexibleNode, int n) {
        int n2;
        int n3 = this.getChildCount();
        FlexibleNode[] flexibleNodeArray = new FlexibleNode[n3 + 1];
        for (n2 = 0; n2 < n; ++n2) {
            flexibleNodeArray[n2] = this.child[n2];
        }
        flexibleNodeArray[n] = flexibleNode;
        for (n2 = n; n2 < n3; ++n2) {
            flexibleNodeArray[n2 + 1] = this.child[n2];
        }
        this.child = flexibleNodeArray;
        flexibleNode.setParent(this);
    }

    public FlexibleNode removeChild(FlexibleNode flexibleNode) {
        int n = this.getChildCount();
        FlexibleNode[] flexibleNodeArray = new FlexibleNode[n - 1];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (this.child[i] != flexibleNode) {
                flexibleNodeArray[n2] = this.child[i];
                ++n2;
                continue;
            }
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        flexibleNode.setParent(null);
        this.child = flexibleNodeArray;
        return flexibleNode;
    }

    public FlexibleNode removeChild(int n) {
        int n2 = this.getChildCount();
        if (n >= n2) {
            throw new IllegalArgumentException("Nonexistent child");
        }
        return this.removeChild(this.child[n]);
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public boolean isExternal() {
        return !this.hasChildren();
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public final int getChildCount() {
        if (this.child == null) {
            return 0;
        }
        return this.child.length;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }
}

