/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchratemodel;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchratemodel.AbstractBranchRateModel;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class DiscretizedBranchRates
extends AbstractBranchRateModel
implements Citable {
    private static final boolean DEFAULT_CACHE_RATES = false;
    private static final String RATE_CATEGORY = "rateCat";
    private final ParametricDistributionModel distributionModel;
    private final TreeParameterModel rateCategories;
    private final int categoryCount;
    private final double step;
    private final double[][] rates;
    private final boolean normalize;
    private final double normalizeBranchRateTo;
    private final TreeModel treeModel;
    private final double logDensityNormalizationConstant;
    private double scaleFactor = 1.0;
    private double storedScaleFactor;
    private boolean updateRateCategories;
    private int currentRateArrayIndex = 0;
    private int storedRateArrayIndex;
    private boolean cacheRates;
    private TreeTrait[] traits;
    public static Citation CITATION = new Citation(new Author[]{new Author("AJ", "Drummond"), new Author("SYW", "Ho"), new Author("MJ", "Phillips"), new Author("A", "Rambaut")}, "Relaxed Phylogenetics and Dating with Confidence", 2006, "PLoS Biology", "4: e88", "10.1371/journal.pbio.0040088");

    public DiscretizedBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel parametricDistributionModel, int n) {
        this(treeModel, parameter, parametricDistributionModel, n, false, Double.NaN, false, false, false);
    }

    public DiscretizedBranchRates(TreeModel treeModel, Parameter parameter, ParametricDistributionModel parametricDistributionModel, int n, boolean bl, double d, boolean bl2, boolean bl3, boolean bl4) {
        super("discretizedBranchRates");
        this.cacheRates = bl4;
        this.rateCategories = new TreeParameterModel((MutableTreeModel)treeModel, parameter, false);
        this.categoryCount = (treeModel.getNodeCount() - 1) * n;
        this.step = 1.0 / (double)this.categoryCount;
        this.rates = new double[2][this.categoryCount];
        this.normalize = bl;
        this.treeModel = treeModel;
        this.treeModel.addKeyword("discretized_branch_rates");
        this.addKeyword("discretized_branch_rates");
        this.distributionModel = parametricDistributionModel;
        this.normalizeBranchRateTo = d;
        Parameter.DefaultBounds defaultBounds = new Parameter.DefaultBounds(this.categoryCount - 1, 0.0, parameter.getDimension());
        parameter.addBounds(defaultBounds);
        for (int i = 0; i < parameter.getDimension(); ++i) {
            if (bl3) continue;
            int n2 = bl2 ? MathUtils.nextInt(parameter.getDimension() * n) : (int)Math.floor(((double)i + 0.5) * (double)n);
            parameter.setParameterValue(i, n2);
        }
        this.addModel(parametricDistributionModel);
        this.addModel(this.rateCategories);
        this.updateRateCategories = true;
        this.logDensityNormalizationConstant = (double)(-parameter.getDimension()) * Math.log(this.categoryCount);
        this.traits = new TreeTrait[2];
        TreeTrait<Double> treeTrait = new TreeTrait<Double>(){

            @Override
            public String getTraitName() {
                return "rate";
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Class getTraitClass() {
                return Double.class;
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return DiscretizedBranchRates.this.getBranchRate(tree, nodeRef);
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                return Double.toString(DiscretizedBranchRates.this.getBranchRate(tree, nodeRef));
            }

            @Override
            public boolean getLoggable() {
                return true;
            }

            public String toString() {
                return "rate";
            }
        };
        TreeTrait<Integer> treeTrait2 = new TreeTrait<Integer>(){

            @Override
            public String getTraitName() {
                return DiscretizedBranchRates.RATE_CATEGORY;
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public Class getTraitClass() {
                return Double.class;
            }

            @Override
            public Integer getTrait(Tree tree, NodeRef nodeRef) {
                return DiscretizedBranchRates.this.getBranchRateCategory(tree, nodeRef);
            }

            @Override
            public String getTraitString(Tree tree, NodeRef nodeRef) {
                return Integer.toString(DiscretizedBranchRates.this.getBranchRateCategory(tree, nodeRef));
            }

            @Override
            public boolean getLoggable() {
                return true;
            }

            public String toString() {
                return DiscretizedBranchRates.RATE_CATEGORY;
            }
        };
        this.traits[0] = treeTrait;
        this.traits[1] = treeTrait2;
    }

    private void computeFactor() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getNode(i);
            if (this.treeModel.isRoot(nodeRef)) continue;
            int n = (int)(this.rateCategories.getNodeValue(this.treeModel, nodeRef) + 0.5);
            d += this.rates[this.currentRateArrayIndex][n] * this.treeModel.getBranchLength(nodeRef);
            d2 += this.treeModel.getBranchLength(nodeRef);
        }
        this.scaleFactor = this.normalizeBranchRateTo / (d / d2);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.distributionModel) {
            this.updateRateCategories = true;
            this.fireModelChanged();
        } else if (model == this.rateCategories) {
            this.fireModelChanged(null, n);
        }
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        if (this.cacheRates) {
            this.storedRateArrayIndex = this.currentRateArrayIndex;
            this.storedScaleFactor = this.scaleFactor;
        }
    }

    @Override
    protected void restoreState() {
        if (this.cacheRates) {
            this.currentRateArrayIndex = this.storedRateArrayIndex;
            this.scaleFactor = this.storedScaleFactor;
        } else {
            this.updateRateCategories = true;
        }
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public final double getBranchRate(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate!";
        if (this.updateRateCategories) {
            this.setupRates();
        }
        int n = (int)(this.rateCategories.getNodeValue(tree, nodeRef) + 0.5);
        return this.rates[this.currentRateArrayIndex][n] * this.scaleFactor;
    }

    public final int getBranchRateCategory(Tree tree, NodeRef nodeRef) {
        assert (!tree.isRoot(nodeRef)) : "root node doesn't have a rate category!";
        if (this.updateRateCategories) {
            this.setupRates();
        }
        return (int)(this.rateCategories.getNodeValue(tree, nodeRef) + 0.5);
    }

    private void setupRates() {
        if (this.cacheRates) {
            this.currentRateArrayIndex = 1 - this.currentRateArrayIndex;
        }
        double d = this.step / 2.0;
        for (int i = 0; i < this.categoryCount; ++i) {
            this.rates[this.currentRateArrayIndex][i] = this.distributionModel.quantile(d);
            d += this.step;
        }
        if (this.normalize) {
            this.computeFactor();
        }
        this.updateRateCategories = false;
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.traits;
    }

    public ParametricDistributionModel getParametricDistributionModel() {
        return this.distributionModel;
    }

    @Override
    public double getLogLikelihood() {
        return this.logDensityNormalizationConstant;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MOLECULAR_CLOCK;
    }

    @Override
    public String getDescription() {
        return "Uncorrelated relaxed clock";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

