/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.stuff;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.branchmodel.HomogeneousBranchModel;
import dr.evomodel.branchmodel.lineagespecific.CountableRealizationsParameter;
import dr.evomodel.siteratemodel.GammaSiteRateModel;
import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.stuff.GenPolyaUrnProcessPrior;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math.MathException;

public class DataSquashingOperator
extends SimpleMCMCOperator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DIST = false;
    private static final boolean DEBUG_DIST_2 = false;
    private static final boolean DEBUG_DIST_3 = false;
    private static final boolean DEBUG_DIST_4 = false;
    private static final boolean DEBUG_ALLOCVAR = false;
    private boolean newCatMethodOne = true;
    private boolean newCatMethodTwo = false;
    private GenPolyaUrnProcessPrior gpupp;
    private PatternList patternList;
    private boolean orderOneAdditions = true;
    private int realizationCount;
    private int mhSteps;
    private int uniquePatternCount;
    private Parameter groupAssignments;
    private Parameter categoriesParameter;
    private CountableRealizationsParameter allParameters;
    private CompoundParameter uniquelyRealizedParameters;
    public List<ParametricMultivariateDistributionModel> baseDistributionList;
    private List<Parameter> massParameterList;
    private TreeDataLikelihood tdl;
    private CompoundLikelihood cl;
    private int order;
    private double sampleProportion;
    private double epsilon;
    private boolean isHMM;
    private Parameter currentGroupAssignments;
    private Parameter currentCategoriesParameter;
    private CompoundParameter currentUniquelyRealizedParameters;
    private int[] sitesStillNeedingUpdate;
    private int numSitesStillNeedingUpdate;
    private boolean cyclical;
    private int distMethod;
    private int fixedNumber;
    private boolean strictCutoff;
    private int parameterDimension;
    private int maxNewCat;
    private boolean old;
    private List<SiteRateModel> siteRateModelList;
    private Tree treeModel;

    public DataSquashingOperator(GenPolyaUrnProcessPrior genPolyaUrnProcessPrior, TreeDataLikelihood treeDataLikelihood, CompoundLikelihood compoundLikelihood, List<SiteRateModel> list, Tree tree, PatternList patternList, int n, double d, boolean bl, int n2, double d2, double d3, int n3, boolean bl2, int n4, boolean bl3) {
        int n5;
        this.old = bl3;
        this.gpupp = genPolyaUrnProcessPrior;
        this.groupAssignments = genPolyaUrnProcessPrior.getGroupAssignments();
        this.realizationCount = this.groupAssignments.getDimension();
        this.categoriesParameter = genPolyaUrnProcessPrior.getCategoriesParameter();
        this.uniquelyRealizedParameters = genPolyaUrnProcessPrior.getUniquelyRealizedParameters();
        this.allParameters = genPolyaUrnProcessPrior.getAllParameters();
        this.massParameterList = genPolyaUrnProcessPrior.getMassParameterList();
        this.baseDistributionList = genPolyaUrnProcessPrior.getBaseDistributionList();
        this.order = genPolyaUrnProcessPrior.getOrder();
        this.isHMM = genPolyaUrnProcessPrior.isHMM();
        this.sampleProportion = d3;
        this.epsilon = d2;
        this.distMethod = n2;
        this.fixedNumber = n3;
        this.cyclical = bl;
        this.strictCutoff = bl2;
        this.tdl = treeDataLikelihood;
        this.cl = compoundLikelihood;
        this.siteRateModelList = list;
        this.treeModel = tree;
        this.patternList = patternList;
        this.uniquePatternCount = patternList.getPatternCount();
        this.mhSteps = n;
        this.currentGroupAssignments = new Parameter.Default(this.groupAssignments.getParameterValues());
        this.currentCategoriesParameter = new Parameter.Default(this.categoriesParameter.getParameterValues());
        this.currentUniquelyRealizedParameters = new CompoundParameter("current");
        for (n5 = 0; n5 < this.uniquelyRealizedParameters.getParameterCount(); ++n5) {
            this.currentUniquelyRealizedParameters.addParameter(new Parameter.Default(this.uniquelyRealizedParameters.getParameter(n5).getParameterValues()));
        }
        this.sitesStillNeedingUpdate = new int[this.realizationCount];
        if (bl) {
            for (n5 = 0; n5 < this.realizationCount; ++n5) {
                this.sitesStillNeedingUpdate[n5] = 1;
            }
        }
        this.numSitesStillNeedingUpdate = this.realizationCount;
        this.parameterDimension = this.uniquelyRealizedParameters.getParameter(0).getSize();
        this.maxNewCat = n4;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        double d = 0.0;
        try {
            d = this.doOp();
        }
        catch (MathException mathException) {
            mathException.printStackTrace();
        }
        return d;
    }

    private double doOp() throws MathException {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object2;
        Object object3;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        for (n15 = 0; n15 < this.categoriesParameter.getSize(); ++n15) {
            if (this.order == 1) {
                this.currentGroupAssignments.setParameterValue(n15, this.groupAssignments.getParameterValue(n15));
            }
            this.currentCategoriesParameter.setParameterValue(n15, this.categoriesParameter.getParameterValue(n15));
        }
        if (this.uniquelyRealizedParameters.getParameterCount() != this.gpupp.maxCategoryCount) {
            throw new RuntimeException("uniquelyRealizedParameters should have same number of parametersas maxCategoryCount!");
        }
        for (n15 = 0; n15 < this.uniquelyRealizedParameters.getParameterCount(); ++n15) {
            for (n14 = 0; n14 < this.uniquelyRealizedParameters.getParameter(n15).getSize(); ++n14) {
                this.currentUniquelyRealizedParameters.getParameter(n15).setParameterValue(n14, this.uniquelyRealizedParameters.getParameter(n15).getParameterValue(n14));
            }
        }
        int[][] nArray = new int[this.gpupp.maxGroupCount][this.currentUniquelyRealizedParameters.getParameterCount()];
        for (n14 = 0; n14 < this.realizationCount; ++n14) {
            int n16 = (int)this.currentGroupAssignments.getParameterValue(n14);
            int n17 = (int)this.currentCategoriesParameter.getParameterValue(n14);
            int[] nArray2 = nArray[n16];
            int n18 = n17;
            nArray2[n18] = nArray2[n18] + 1;
        }
        n14 = 0;
        int[] nArray3 = new int[this.currentUniquelyRealizedParameters.getParameterCount()];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.gpupp.maxCategoryCount);
        int[] nArray4 = new int[this.gpupp.maxCategoryCount];
        for (int i = 0; i < nArray[0].length; ++i) {
            for (n13 = 0; n13 < nArray.length; ++n13) {
                nArray3[i] = nArray3[i] + nArray[n13][i];
            }
            if (nArray3[i] > 0) {
                ++n14;
                nArray4[i] = 1;
                continue;
            }
            arrayList.add(i);
            nArray4[i] = 0;
        }
        if (this.isHMM) {
            n14 = this.gpupp.maxCategoryCount;
        }
        if (arrayList.size() < this.maxNewCat && !this.isHMM) {
            throw new RuntimeException("There are not enough unoccupied categories");
        }
        int[] nArray5 = new int[this.gpupp.maxGroupCount];
        for (n13 = 0; n13 < this.gpupp.maxGroupCount; ++n13) {
            for (n12 = 0; n12 < this.gpupp.maxCategoryCount; ++n12) {
                nArray5[n13] = nArray5[n13] + nArray[n13][n12];
            }
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.realizationCount);
        n12 = 0;
        if (this.cyclical) {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                if (this.sitesStillNeedingUpdate[n11] != 1) continue;
                arrayList2.add(n11);
            }
        } else {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                arrayList2.add(n11);
            }
        }
        if (arrayList2.size() == 0) {
            for (n11 = 0; n11 < this.realizationCount; ++n11) {
                arrayList2.add(n11);
            }
        }
        n11 = MathUtils.nextInt(arrayList2.size());
        int n19 = (Integer)arrayList2.get(n11);
        int[] nArray6 = new int[this.gpupp.maxCategoryCount];
        int n20 = 0;
        for (n10 = 0; n10 < this.cl.getLikelihoodCount() && ((TreeDataLikelihood)this.cl.getLikelihood(n10)).getDataLikelihoodDelegate() != null; ++n10) {
            ++n20;
        }
        if (!this.isHMM) {
            for (n10 = 0; n10 < this.maxNewCat; ++n10) {
                int n21;
                nArray6[((Integer)arrayList.get((int)n10)).intValue()] = 1;
                object3 = new double[this.parameterDimension];
                int n22 = 0;
                for (n21 = 0; n21 < this.baseDistributionList.size(); ++n21) {
                    object2 = this.baseDistributionList.get(n21).nextRandom();
                    for (int i = 0; i < ((double[])object2).length; ++i) {
                        object3[n22] = object2[i];
                        ++n22;
                    }
                }
                for (n21 = 0; n21 < this.parameterDimension; ++n21) {
                    this.uniquelyRealizedParameters.getParameter((Integer)arrayList.get(n10)).setParameterValue(n21, object3[n21]);
                }
                if (this.old) continue;
                if ((Integer)arrayList.get(n10) >= n20) {
                    if ((Integer)arrayList.get(n10) > n20) {
                        throw new RuntimeException("next empty category should not be greater than currentNumDelegates");
                    }
                    System.out.println("New data likelihood delegate being created");
                    GammaSiteRateModel gammaSiteRateModel = (GammaSiteRateModel)this.siteRateModelList.get(n20);
                    object2 = new HomogeneousBranchModel(gammaSiteRateModel.getSubstitutionModel(), null);
                    Parameter.Default default_ = new Parameter.Default(1);
                    default_.setParameterValue(0, n20);
                    BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(this.treeModel, this.patternList, (BranchModel)object2, gammaSiteRateModel, ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getUseAmbiguities(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreferGPU(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getRescalingScheme(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getDelayRescalingUntilUnderflow(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreOrderSettings(), this.categoriesParameter, default_);
                    ((TreeDataLikelihood)this.cl.getLikelihood((Integer)arrayList.get(n10))).setDataLikelihoodDelegate(beagleDataLikelihoodDelegate);
                    ++n20;
                }
                this.cl.getLikelihood((Integer)arrayList.get(n10)).makeDirty();
            }
            if (this.old) {
                this.tdl.makeDirty();
            }
        }
        double[] dArray = null;
        if (this.old) {
            dArray = this.tdl.getDataLikelihoodDelegate().getSiteLogLikelihoods();
        }
        object3 = null;
        object3 = this.old ? (Object)this.computeLogMassFunctions(arrayList2, n14, nArray, nArray5, this.currentGroupAssignments, this.baseDistributionList, this.currentUniquelyRealizedParameters, this.currentCategoriesParameter, dArray) : (Object)this.computeLogMassFunctionsNew(arrayList2, n14, nArray, nArray5, this.currentGroupAssignments, this.baseDistributionList, this.currentUniquelyRealizedParameters, this.currentCategoriesParameter);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(arrayList2.size());
        if (this.distMethod == 1) {
            if (arrayList2.size() >= 2) {
                double d = this.computeThreshold(this.epsilon, this.sampleProportion, arrayList2, (double[][])object3, n14);
                double[] dArray2 = this.computeHellingerDist((double[][])object3, n19, arrayList2, n14);
                for (int i = 0; i < arrayList2.size(); ++i) {
                    if (!(dArray2[i] <= d)) continue;
                    arrayList3.add(arrayList2.get(i));
                    if (!this.cyclical || this.order != 0) continue;
                    this.sitesStillNeedingUpdate[arrayList2.get((int)i).intValue()] = 0;
                }
            } else {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList3.add(arrayList2.get(i));
                    if (!this.cyclical || this.order != 0) continue;
                    this.sitesStillNeedingUpdate[arrayList2.get((int)i).intValue()] = 0;
                }
            }
        }
        if (this.distMethod == 2) {
            int n23 = (int)(this.epsilon * (double)arrayList2.size());
            if (this.fixedNumber > 0) {
                n23 = this.fixedNumber;
                if (this.fixedNumber > arrayList2.size()) {
                    n23 = arrayList2.size();
                }
            }
            if (n23 == 0) {
                n23 = arrayList2.size();
            }
            if (n14 > 1) {
                int n24;
                object2 = this.computeHellingerDist((double[][])object3, n19, arrayList2, n14);
                double[] dArray3 = new double[((double[])object2).length];
                System.arraycopy(object2, 0, dArray3, 0, ((Object)object2).length);
                Arrays.sort(dArray3);
                double d = dArray3[n23 - 1];
                if (this.fixedNumber == 1) {
                    arrayList3.add(n19);
                } else if (this.strictCutoff) {
                    for (n24 = 0; n24 < arrayList2.size(); ++n24) {
                        if (!(object2[n24] <= d) || arrayList3.size() >= n23) continue;
                        arrayList3.add(arrayList2.get(n24));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[arrayList2.get((int)n24).intValue()] = 0;
                    }
                } else {
                    for (n24 = 0; n24 < arrayList2.size(); ++n24) {
                        if (!(object2[n24] <= d)) continue;
                        arrayList3.add(arrayList2.get(n24));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[arrayList2.get((int)n24).intValue()] = 0;
                    }
                }
            } else {
                object2 = new ArrayList(arrayList2.size());
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((ArrayList)object2).add(i);
                }
                Random random = new Random(MathUtils.getSeed());
                Collections.shuffle(object2, random);
                if (this.fixedNumber == 1) {
                    arrayList3.add(n19);
                } else {
                    for (int i = 0; i < n23; ++i) {
                        arrayList3.add((Integer)((ArrayList)object2).get(i));
                        if (!this.cyclical || this.order != 0) continue;
                        this.sitesStillNeedingUpdate[((Integer)((ArrayList)object2).get((int)i)).intValue()] = 0;
                    }
                }
            }
        }
        if (arrayList3.size() == 0) {
            System.err.println("0 sites in update");
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(0);
        if (this.order == 1) {
            if (this.cyclical) {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    if (Math.abs((Integer)arrayList3.get(i) - n19) % 2 != 0) continue;
                    arrayList4.add((Integer)arrayList3.get(i));
                    this.sitesStillNeedingUpdate[((Integer)arrayList3.get((int)i)).intValue()] = 0;
                }
            } else {
                for (int i = 0; i < arrayList3.size(); ++i) {
                    if (Math.abs((Integer)arrayList3.get(i) - n19) % 2 != 0) continue;
                    arrayList4.add((Integer)arrayList3.get(i));
                }
            }
        } else {
            arrayList4 = arrayList3;
        }
        if (this.cyclical) {
            this.numSitesStillNeedingUpdate -= arrayList4.size();
        }
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>(0);
        if (this.order == 1) {
            for (int i = 0; i < arrayList4.size(); ++i) {
                arrayList5.add((Integer)arrayList4.get(i));
                int n25 = (Integer)arrayList4.get(i) + 1;
                if (n25 >= this.realizationCount) continue;
                arrayList5.add(n25);
            }
        } else {
            arrayList5 = arrayList4;
        }
        double[] dArray4 = new double[this.gpupp.maxCategoryCount];
        if (n14 + this.maxNewCat > this.gpupp.maxCategoryCount && !this.isHMM) {
            throw new RuntimeException("There are not enough empty categories");
        }
        double[][] dArray5 = new double[this.gpupp.maxGroupCount][this.gpupp.maxCategoryCount];
        double[][] dArray6 = new double[this.gpupp.maxGroupCount][this.gpupp.maxCategoryCount];
        double[] dArray7 = new double[this.gpupp.maxGroupCount];
        int n26 = (int)this.currentGroupAssignments.getParameterValue(n19);
        for (n9 = 0; n9 < this.realizationCount; ++n9) {
            int n27 = (int)this.currentGroupAssignments.getParameterValue(n9);
            n8 = (int)this.currentCategoriesParameter.getParameterValue(n9);
            if (arrayList4.contains(n9)) continue;
            double[] dArray8 = dArray5[n27];
            int n28 = n8;
            dArray8[n28] = dArray8[n28] + 1.0;
            if (arrayList5.contains(n9)) continue;
            double[] dArray9 = dArray6[n27];
            int n29 = n8;
            dArray9[n29] = dArray9[n29] + 1.0;
            int n30 = n27;
            dArray7[n30] = dArray7[n30] + 1.0;
        }
        double[] dArray10 = new double[this.gpupp.maxCategoryCount];
        for (n8 = 0; n8 < this.gpupp.maxCategoryCount; ++n8) {
            if (nArray6[n8] == 1 && !this.isHMM) {
                if (this.old) {
                    n9 = this.uniquePatternCount * n8 + this.patternList.getPatternIndex(n19);
                    dArray4[n8] = dArray[n9];
                } else {
                    dArray4[n8] = ((TreeDataLikelihood)this.cl.getLikelihood(n8)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n19)];
                }
                if (dArray4[n8] == Double.POSITIVE_INFINITY || Double.isNaN(dArray4[n8])) {
                    dArray4[n8] = Double.NEGATIVE_INFINITY;
                }
                dArray4[n8] = dArray4[n8] + Math.log(this.massParameterList.get(n26).getParameterValue(0) / (double)this.maxNewCat) - Math.log(this.massParameterList.get(n26).getParameterValue(0) + dArray7[n26]);
                continue;
            }
            if (dArray5[n26][n8] > 0.0 || this.order == 1) {
                int n31;
                int n32;
                if (this.old) {
                    n9 = this.uniquePatternCount * n8 + this.patternList.getPatternIndex(n19);
                    dArray4[n8] = dArray[n9];
                } else {
                    dArray4[n8] = ((TreeDataLikelihood)this.cl.getLikelihood(n8)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n19)];
                }
                dArray4[n8] = dArray4[n8] + Math.log(this.massParameterList.get(n26).getParameterValue(0) * this.gpupp.getSingletonProbability(this.currentUniquelyRealizedParameters.getParameter(n8), this.baseDistributionList, n26) + dArray6[n26][n8]);
                dArray4[n8] = dArray4[n8] - Math.log(this.massParameterList.get(n26).getParameterValue(0) + dArray7[n26]);
                if (this.order != 1 || !this.orderOneAdditions || n19 + 1 >= this.realizationCount) continue;
                int n33 = 1 + n8;
                int n34 = 0;
                n7 = 0;
                if (n26 == n33) {
                    n34 = 1;
                }
                if ((n32 = n8) == (n31 = (int)this.currentCategoriesParameter.getParameterValue(n19 + 1))) {
                    n7 = 1;
                }
                dArray4[n8] = dArray4[n8] + Math.log(this.massParameterList.get(n33).getParameterValue(0) * this.gpupp.getSingletonProbability(this.currentUniquelyRealizedParameters.getParameter(n31), this.baseDistributionList, n33) + dArray6[n33][n31] + (double)(n34 * n7));
                dArray4[n8] = dArray4[n8] - Math.log(this.massParameterList.get(n33).getParameterValue(0) + dArray7[n33] + (double)n34);
                continue;
            }
            dArray4[n8] = Double.NEGATIVE_INFINITY;
        }
        double d = dArray4[0];
        for (n7 = 1; n7 < dArray4.length; ++n7) {
            if (!(dArray4[n7] > d)) continue;
            d = dArray4[n7];
        }
        double[] dArray11 = new double[dArray4.length];
        double d2 = 0.0;
        for (n6 = 0; n6 < dArray11.length; ++n6) {
            dArray11[n6] = Math.exp(dArray4[n6] - d);
            d2 += dArray11[n6];
        }
        for (n6 = 0; n6 < dArray11.length; ++n6) {
            dArray11[n6] = dArray11[n6] / d2;
        }
        int[] nArray7 = new int[arrayList4.size()];
        for (int i = 0; i < nArray7.length; ++i) {
            nArray7[i] = MathUtils.randomChoicePDF(dArray11);
        }
        double d3 = 0.0;
        int[] nArray8 = new int[this.gpupp.maxCategoryCount];
        for (n5 = 0; n5 < nArray7.length; ++n5) {
            if (nArray6[nArray7[n5]] == 1) {
                nArray8[nArray7[n5]] = 1;
            }
            this.categoriesParameter.setParameterValue((Integer)arrayList4.get(n5), nArray7[n5]);
            d3 -= Math.log(dArray11[nArray7[n5]]);
        }
        if (!this.isHMM) {
            for (n5 = 0; n5 < this.gpupp.maxCategoryCount; ++n5) {
                if (nArray8[n5] != 1) continue;
                d3 -= this.gpupp.getLogDensity(this.uniquelyRealizedParameters.getParameter(n5), n26);
            }
        }
        if (this.order == 1) {
            for (n5 = 0; n5 < arrayList4.size(); ++n5) {
                if ((Integer)arrayList4.get(n5) + 1 >= this.realizationCount) continue;
                int n35 = (int)this.categoriesParameter.getParameterValue((Integer)arrayList4.get(n5));
                this.gpupp.setGroup(this.groupAssignments, (Integer)arrayList4.get(n5) + 1, n35);
            }
        }
        int[][] nArray9 = new int[this.gpupp.maxGroupCount][this.uniquelyRealizedParameters.getParameterCount()];
        double[] dArray12 = new double[this.gpupp.maxCategoryCount];
        double[] dArray13 = new double[this.gpupp.maxCategoryCount];
        double[][] dArray14 = new double[this.gpupp.maxGroupCount][this.gpupp.maxCategoryCount];
        double[][] dArray15 = new double[this.gpupp.maxGroupCount][this.gpupp.maxCategoryCount];
        double[] dArray16 = new double[this.gpupp.maxGroupCount];
        int n36 = (int)this.groupAssignments.getParameterValue(n19);
        for (n4 = 0; n4 < this.realizationCount; ++n4) {
            int n37 = (int)this.groupAssignments.getParameterValue(n4);
            int n38 = (int)this.categoriesParameter.getParameterValue(n4);
            int[] nArray10 = nArray9[n37];
            int n39 = n38;
            nArray10[n39] = nArray10[n39] + 1;
            if (arrayList4.contains(n4)) continue;
            double[] dArray17 = dArray14[n37];
            int n40 = n38;
            dArray17[n40] = dArray17[n40] + 1.0;
            if (arrayList5.contains(n4)) continue;
            double[] dArray18 = dArray15[n37];
            int n41 = n38;
            dArray18[n41] = dArray18[n41] + 1.0;
            int n42 = n37;
            dArray16[n42] = dArray16[n42] + 1.0;
        }
        n4 = 0;
        int[] nArray11 = new int[this.uniquelyRealizedParameters.getParameterCount()];
        int[] nArray12 = new int[this.gpupp.maxCategoryCount];
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>(this.gpupp.maxCategoryCount);
        for (int i = 0; i < nArray9[0].length; ++i) {
            for (int j = 0; j < nArray9.length; ++j) {
                nArray11[i] = nArray11[i] + nArray9[j][i];
            }
            if (nArray11[i] > 0) {
                ++n4;
                nArray12[i] = 1;
                continue;
            }
            arrayList6.add(i);
        }
        int[] nArray13 = new int[this.gpupp.maxCategoryCount];
        int[] nArray14 = new int[this.gpupp.maxCategoryCount];
        int n43 = 0;
        for (n3 = 0; n3 < this.gpupp.maxCategoryCount; ++n3) {
            if (nArray4[n3] != 1 || nArray12[n3] == 1) continue;
            nArray13[n3] = 1;
            nArray14[n3] = 1;
            ++n43;
        }
        if (n43 < this.maxNewCat && this.maxNewCat <= arrayList6.size()) {
            n3 = this.maxNewCat - n43;
            for (n2 = 0; n2 < n3; ++n2) {
                int n44;
                if (nArray14[(Integer)arrayList6.get(n2)] != 1) {
                    nArray14[((Integer)arrayList6.get((int)n2)).intValue()] = 1;
                }
                double[] dArray19 = new double[this.parameterDimension];
                n = 0;
                for (n44 = 0; n44 < this.baseDistributionList.size(); ++n44) {
                    object = this.baseDistributionList.get(n44).nextRandom();
                    for (int i = 0; i < ((int[])object).length; ++i) {
                        dArray19[n] = object[i];
                        ++n;
                    }
                }
                for (n44 = 0; n44 < this.parameterDimension; ++n44) {
                    this.uniquelyRealizedParameters.getParameter((Integer)arrayList6.get(n2)).setParameterValue(n44, dArray19[n44]);
                }
                if ((Integer)arrayList6.get(n2) >= n20) {
                    if ((Integer)arrayList6.get(n2) > n20) {
                        throw new RuntimeException("next empty category should not be greater than currentNumDelegates");
                    }
                    System.out.println("New data likelihood delegate being created");
                    GammaSiteRateModel gammaSiteRateModel = (GammaSiteRateModel)this.siteRateModelList.get(n20);
                    object = new HomogeneousBranchModel(gammaSiteRateModel.getSubstitutionModel(), null);
                    Parameter.Default default_ = new Parameter.Default(1);
                    default_.setParameterValue(0, n20);
                    BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate = new BeagleDataLikelihoodDelegate(this.treeModel, this.patternList, (BranchModel)object, gammaSiteRateModel, ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getUseAmbiguities(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreferGPU(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getRescalingScheme(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getDelayRescalingUntilUnderflow(), ((TreeDataLikelihood)this.cl.getLikelihood(0)).getDataLikelihoodDelegate().getPreOrderSettings(), this.categoriesParameter, default_);
                    ((TreeDataLikelihood)this.cl.getLikelihood((Integer)arrayList6.get(n2))).setDataLikelihoodDelegate(beagleDataLikelihoodDelegate);
                    ++n20;
                    continue;
                }
                this.cl.getLikelihood((Integer)arrayList6.get(n2)).makeDirty();
            }
        }
        if (!(n43 <= this.maxNewCat && this.maxNewCat <= arrayList6.size() || this.isHMM)) {
            d3 = Double.NEGATIVE_INFINITY;
        } else {
            int n45;
            int n46;
            for (n3 = 0; n3 < this.gpupp.maxCategoryCount; ++n3) {
                if (nArray14[n3] == 1 && !this.isHMM) {
                    if (this.old) {
                        n9 = this.uniquePatternCount * n3 + this.patternList.getPatternIndex(n19);
                        dArray13[n3] = dArray[n9];
                    } else {
                        dArray13[n3] = ((TreeDataLikelihood)this.cl.getLikelihood(n3)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n19)];
                    }
                    dArray13[n3] = dArray13[n3] + Math.log(this.massParameterList.get(n26).getParameterValue(0) / (double)this.maxNewCat) - Math.log(this.massParameterList.get(n26).getParameterValue(0) + dArray16[n26]);
                    continue;
                }
                if (dArray14[n36][n3] > 0.0 || this.order == 1) {
                    int n47;
                    if (this.old) {
                        n9 = this.uniquePatternCount * n3 + this.patternList.getPatternIndex(n19);
                        dArray13[n3] = dArray[n9];
                    } else {
                        dArray13[n3] = ((TreeDataLikelihood)this.cl.getLikelihood(n3)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(n19)];
                    }
                    dArray13[n3] = dArray13[n3] + Math.log(this.massParameterList.get(n36).getParameterValue(0) * this.gpupp.getSingletonProbability(this.uniquelyRealizedParameters.getParameter(n3), this.baseDistributionList, n36) + dArray15[n36][n3]);
                    dArray13[n3] = dArray13[n3] - Math.log(this.massParameterList.get(n36).getParameterValue(0) + dArray16[n36]);
                    if (this.order != 1 || !this.orderOneAdditions || n19 + 1 >= this.realizationCount) continue;
                    int n48 = n3 + 1;
                    n2 = 0;
                    int n49 = 0;
                    if (n36 == n48) {
                        n2 = 1;
                    }
                    if ((n = n3) == (n47 = (int)this.categoriesParameter.getParameterValue(n19 + 1))) {
                        n49 = 1;
                    }
                    dArray13[n3] = dArray13[n3] + Math.log(this.massParameterList.get(n48).getParameterValue(0) * this.gpupp.getSingletonProbability(this.uniquelyRealizedParameters.getParameter(n47), this.baseDistributionList, n48) + dArray15[n48][n47] + (double)(n2 * n49));
                    dArray13[n3] = dArray13[n3] - Math.log(this.massParameterList.get(n48).getParameterValue(0) + dArray16[n48] + (double)n2);
                    continue;
                }
                dArray13[n3] = Double.NEGATIVE_INFINITY;
            }
            double d4 = dArray13[0];
            for (int i = 1; i < dArray13.length; ++i) {
                if (!(dArray13[i] > d4)) continue;
                d4 = dArray13[i];
            }
            double d5 = 0.0;
            for (n46 = 0; n46 < dArray12.length; ++n46) {
                dArray12[n46] = Math.exp(dArray13[n46] - d4);
                d5 += dArray12[n46];
            }
            for (n46 = 0; n46 < dArray12.length; ++n46) {
                dArray12[n46] = dArray12[n46] / d5;
            }
            object = new int[this.gpupp.maxCategoryCount];
            for (n45 = 0; n45 < arrayList4.size(); ++n45) {
                n46 = (int)this.currentCategoriesParameter.getParameterValue((Integer)arrayList4.get(n45));
                d3 += Math.log(dArray12[n46]);
                if (nArray13[n46] != 1) continue;
                object[n46] = 1;
            }
            if (!this.isHMM) {
                for (n45 = 0; n45 < this.gpupp.maxCategoryCount; ++n45) {
                    if (nArray13[n45] != 1) continue;
                    if (object[n45] != 1) {
                        throw new RuntimeException("problem in keeping track of current categories that are unoccupied in proposal");
                    }
                    d3 += this.gpupp.getLogDensity(this.uniquelyRealizedParameters.getParameter(n45), n26);
                }
            }
        }
        if (this.cyclical && this.numSitesStillNeedingUpdate == 0) {
            Arrays.fill(this.sitesStillNeedingUpdate, 1);
            this.numSitesStillNeedingUpdate = this.sitesStillNeedingUpdate.length;
        }
        return d3;
    }

    private int drawRandomElementFromSet(ArrayList<Integer> arrayList) {
        int n = MathUtils.nextInt(arrayList.size());
        return arrayList.get(n);
    }

    private double[] computeHellingerDist(double[][] dArray, int n, ArrayList<Integer> arrayList, int n2) {
        double[] dArray2 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (n == arrayList.get(i)) {
                dArray2[i] = 0.0;
                continue;
            }
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += Math.sqrt(Math.exp(dArray[n][j]) * Math.exp(dArray[arrayList.get(i)][j]));
            }
            dArray2[i] = 2.0 * (1.0 - d);
        }
        return dArray2;
    }

    private double[] getUnsortedHellingerDistances(double[][] dArray, ArrayList<Integer> arrayList, int n) {
        double[] dArray2 = new double[arrayList.size() * (arrayList.size() - 1) / 2];
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                double d = 0.0;
                for (int k = 0; k < n; ++k) {
                    d += Math.sqrt(Math.exp(dArray[arrayList.get(i)][k]) * Math.exp(dArray[arrayList.get(j)][k]));
                }
                dArray2[n2] = 2.0 * (1.0 - d);
                ++n2;
            }
        }
        return dArray2;
    }

    private double[][] computeLogMassFunctions(ArrayList<Integer> arrayList, int n, int[][] nArray, int[] nArray2, Parameter parameter, List<ParametricMultivariateDistributionModel> list, CompoundParameter compoundParameter, Parameter parameter2, double[] dArray) {
        double[][] dArray2 = new double[this.realizationCount][n];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            double d = 0.0;
            int n3 = 0;
            for (int j = 0; j < this.gpupp.maxCategoryCount; ++j) {
                int n4 = (int)parameter.getParameterValue(arrayList.get(i));
                if (nArray[n4][j] == 0 && !this.isHMM) continue;
                n2 = this.uniquePatternCount * j + this.patternList.getPatternIndex(arrayList.get(i));
                dArray2[arrayList.get((int)i).intValue()][n3] = dArray[n2];
                dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] + Math.log(this.massParameterList.get(n4).getParameterValue(0) * this.gpupp.getSingletonProbability(compoundParameter.getParameter(j), list, n4) + (double)nArray[n4][j]);
                dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] - Math.log(this.massParameterList.get(n4).getParameterValue(0) + (double)nArray2[n4]);
                if (this.order == 1 && this.orderOneAdditions && arrayList.get(i) + 1 < this.realizationCount) {
                    int n5;
                    int n6;
                    int n7 = j + 1;
                    int n8 = 0;
                    int n9 = 0;
                    if (n4 == n7) {
                        n8 = 1;
                    }
                    if ((n6 = j) == (n5 = (int)parameter2.getParameterValue(arrayList.get(i) + 1))) {
                        n9 = 1;
                    }
                    dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] + Math.log(this.massParameterList.get(n7).getParameterValue(0) * this.gpupp.getSingletonProbability(compoundParameter.getParameter(n5), list, n7) + (double)nArray[n7][n5] + (double)(n8 * n9));
                    dArray2[arrayList.get((int)i).intValue()][n3] = dArray2[arrayList.get(i)][n3] - Math.log(this.massParameterList.get(n7).getParameterValue(0) + (double)nArray2[n7] + (double)n8);
                }
                ++n3;
            }
            double d2 = dArray2[arrayList.get(i)][0];
            for (n2 = 1; n2 < n; ++n2) {
                if (!(dArray2[arrayList.get(i)][n2] > d2)) continue;
                d2 = dArray2[arrayList.get(i)][n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[arrayList.get((int)i).intValue()][n2] = dArray2[arrayList.get(i)][n2] - d2;
                d += Math.exp(dArray2[arrayList.get(i)][n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray2[arrayList.get((int)i).intValue()][n2] = dArray2[arrayList.get(i)][n2] - Math.log(d);
            }
        }
        return dArray2;
    }

    private double[][] computeLogMassFunctionsNew(ArrayList<Integer> arrayList, int n, int[][] nArray, int[] nArray2, Parameter parameter, List<ParametricMultivariateDistributionModel> list, CompoundParameter compoundParameter, Parameter parameter2) {
        double[][] dArray = new double[this.realizationCount][n];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n2;
            double d = 0.0;
            int n3 = 0;
            for (int j = 0; j < this.gpupp.maxCategoryCount; ++j) {
                int n4 = (int)parameter.getParameterValue(arrayList.get(i));
                if (nArray[n4][j] == 0 && !this.isHMM) continue;
                dArray[arrayList.get((int)i).intValue()][n3] = ((TreeDataLikelihood)this.cl.getLikelihood(j)).getDataLikelihoodDelegate().getSiteLogLikelihoods()[this.patternList.getPatternIndex(arrayList.get(i))];
                dArray[arrayList.get((int)i).intValue()][n3] = dArray[arrayList.get(i)][n3] + Math.log(this.massParameterList.get(n4).getParameterValue(0) * this.gpupp.getSingletonProbability(compoundParameter.getParameter(j), list, n4) + (double)nArray[n4][j]);
                dArray[arrayList.get((int)i).intValue()][n3] = dArray[arrayList.get(i)][n3] - Math.log(this.massParameterList.get(n4).getParameterValue(0) + (double)nArray2[n4]);
                if (this.order == 1 && this.orderOneAdditions && arrayList.get(i) + 1 < this.realizationCount) {
                    int n5;
                    int n6;
                    n2 = j + 1;
                    int n7 = 0;
                    int n8 = 0;
                    if (n4 == n2) {
                        n7 = 1;
                    }
                    if ((n6 = j) == (n5 = (int)parameter2.getParameterValue(arrayList.get(i) + 1))) {
                        n8 = 1;
                    }
                    dArray[arrayList.get((int)i).intValue()][n3] = dArray[arrayList.get(i)][n3] + Math.log(this.massParameterList.get(n2).getParameterValue(0) * this.gpupp.getSingletonProbability(compoundParameter.getParameter(n5), list, n2) + (double)nArray[n2][n5] + (double)(n7 * n8));
                    dArray[arrayList.get((int)i).intValue()][n3] = dArray[arrayList.get(i)][n3] - Math.log(this.massParameterList.get(n2).getParameterValue(0) + (double)nArray2[n2] + (double)n7);
                }
                ++n3;
            }
            double d2 = dArray[arrayList.get(i)][0];
            for (n2 = 1; n2 < n; ++n2) {
                if (!(dArray[arrayList.get(i)][n2] > d2)) continue;
                d2 = dArray[arrayList.get(i)][n2];
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[arrayList.get((int)i).intValue()][n2] = dArray[arrayList.get(i)][n2] - d2;
                d += Math.exp(dArray[arrayList.get(i)][n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                dArray[arrayList.get((int)i).intValue()][n2] = dArray[arrayList.get(i)][n2] - Math.log(d);
            }
        }
        return dArray;
    }

    private double computeThreshold(double d, double d2, ArrayList<Integer> arrayList, double[][] dArray, int n) {
        double d3;
        int n2 = (int)(d2 * (double)arrayList.size());
        if (n2 < 2) {
            n2 = 2;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(arrayList.get(i));
        }
        Random random = new Random(MathUtils.getSeed());
        Collections.shuffle(arrayList2, random);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList3.add((Integer)arrayList2.get(i));
        }
        double[] dArray2 = this.getUnsortedHellingerDistances(dArray, arrayList3, n);
        Arrays.sort(dArray2, 0, dArray2.length - 1);
        int n3 = (int)(d * (double)n2 * (double)(n2 - 1) / 2.0);
        if (n3 == 0) {
            n3 = 1;
        }
        if ((d3 = dArray2[n3 - 1]) < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    @Override
    public String getOperatorName() {
        return "dataSquashingOperator";
    }
}

