/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.aminoacid;

import dr.evolution.datatype.AminoAcids;
import dr.evomodel.substmodel.EmpiricalRateMatrix;
import dr.util.Author;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class MTDEU
extends EmpiricalRateMatrix.AbstractAminoAcid {
    public static final MTDEU INSTANCE = new MTDEU();
    public static Citation CITATION = new Citation(new Author[]{new Author("VS", "Le"), new Author("CC", "Dang"), new Author("QS", "Le")}, "Improved mitochondrial amino acid substitution models for metazoan evolutionary studies", 2017, "J Mol Evol", 17, 136, -1);

    private MTDEU() {
        super("mtDeu");
        int n = AminoAcids.INSTANCE.getStateCount();
        double[][] dArray = new double[n][n];
        dArray[0][1] = 0.579999479;
        dArray[0][2] = 0.539999739;
        dArray[0][3] = 0.810000261;
        dArray[0][4] = 0.560000261;
        dArray[0][5] = 0.570000521;
        dArray[0][6] = 1.05;
        dArray[0][7] = 1.790001042;
        dArray[0][8] = 0.270000521;
        dArray[0][9] = 0.360000261;
        dArray[0][10] = 0.3;
        dArray[0][11] = 0.35;
        dArray[0][12] = 0.539999739;
        dArray[0][13] = 0.15;
        dArray[0][14] = 1.939998436;
        dArray[0][15] = 3.779994267;
        dArray[0][16] = 4.75;
        dArray[0][17] = 0.09;
        dArray[0][18] = 0.11;
        dArray[0][19] = 2.979999479;
        dArray[1][2] = 0.449999033;
        dArray[1][3] = 0.16;
        dArray[1][4] = 1.12999942;
        dArray[1][5] = 3.099998065;
        dArray[1][6] = 0.290000193;
        dArray[1][7] = 1.37000058;
        dArray[1][8] = 3.279990714;
        dArray[1][9] = 0.219999613;
        dArray[1][10] = 0.380000387;
        dArray[1][11] = 6.460002708;
        dArray[1][12] = 0.439999226;
        dArray[1][13] = 0.05;
        dArray[1][14] = 0.739999226;
        dArray[1][15] = 1.009999807;
        dArray[1][16] = 0.639999226;
        dArray[1][17] = 1.260000774;
        dArray[1][18] = 0.2;
        dArray[1][19] = 0.17;
        dArray[2][3] = 5.28000938;
        dArray[2][4] = 0.34;
        dArray[2][5] = 0.86;
        dArray[2][6] = 0.58;
        dArray[2][7] = 0.810001172;
        dArray[2][8] = 3.910001172;
        dArray[2][9] = 0.469998828;
        dArray[2][10] = 0.12;
        dArray[2][11] = 2.629991793;
        dArray[2][12] = 0.3;
        dArray[2][13] = 0.1;
        dArray[2][14] = 0.15;
        dArray[2][15] = 5.029991793;
        dArray[2][16] = 2.32;
        dArray[2][17] = 0.08;
        dArray[2][18] = 0.7;
        dArray[2][19] = 0.16;
        dArray[3][4] = 0.1;
        dArray[3][5] = 0.490000776;
        dArray[3][6] = 7.669990688;
        dArray[3][7] = 1.3;
        dArray[3][8] = 1.120000388;
        dArray[3][9] = 0.11;
        dArray[3][10] = 0.07;
        dArray[3][11] = 0.259999224;
        dArray[3][12] = 0.15;
        dArray[3][13] = 0.04;
        dArray[3][14] = 0.15;
        dArray[3][15] = 0.590000776;
        dArray[3][16] = 0.379999612;
        dArray[3][17] = 0.04;
        dArray[3][18] = 0.459999224;
        dArray[3][19] = 0.309999224;
        dArray[4][5] = 0.09;
        dArray[4][6] = 0.05;
        dArray[4][7] = 0.590001515;
        dArray[4][8] = 0.690001515;
        dArray[4][9] = 0.17;
        dArray[4][10] = 0.23;
        dArray[4][11] = 0.07;
        dArray[4][12] = 0.31;
        dArray[4][13] = 0.77999798;
        dArray[4][14] = 0.14;
        dArray[4][15] = 2.230000505;
        dArray[4][16] = 0.42;
        dArray[4][17] = 1.150002525;
        dArray[4][18] = 2.090001515;
        dArray[4][19] = 0.62000202;
        dArray[5][6] = 3.230000982;
        dArray[5][7] = 0.259999509;
        dArray[5][8] = 5.969989203;
        dArray[5][9] = 0.09;
        dArray[5][10] = 0.719999018;
        dArray[5][11] = 2.920003926;
        dArray[5][12] = 0.430000982;
        dArray[5][13] = 0.04;
        dArray[5][14] = 1.640000491;
        dArray[5][15] = 0.530000982;
        dArray[5][16] = 0.509999509;
        dArray[5][17] = 0.18;
        dArray[5][18] = 0.24;
        dArray[5][19] = 0.2;
        dArray[6][7] = 1.19;
        dArray[6][8] = 0.26;
        dArray[6][9] = 0.12;
        dArray[6][10] = 0.09;
        dArray[6][11] = 1.809995148;
        dArray[6][12] = 0.18;
        dArray[6][13] = 0.05;
        dArray[6][14] = 0.18;
        dArray[6][15] = 0.3;
        dArray[6][16] = 0.32;
        dArray[6][17] = 0.1;
        dArray[6][18] = 0.07;
        dArray[6][19] = 0.45;
        dArray[7][8] = 0.230000547;
        dArray[7][9] = 0.06;
        dArray[7][10] = 0.06;
        dArray[7][11] = 0.269999453;
        dArray[7][12] = 0.140000273;
        dArray[7][13] = 0.05;
        dArray[7][14] = 0.240000273;
        dArray[7][15] = 2.010006562;
        dArray[7][16] = 0.330000547;
        dArray[7][17] = 0.55;
        dArray[7][18] = 0.08;
        dArray[7][19] = 0.469999453;
        dArray[8][9] = 0.16;
        dArray[8][10] = 0.559998257;
        dArray[8][11] = 0.45;
        dArray[8][12] = 0.33;
        dArray[8][13] = 0.4;
        dArray[8][14] = 1.15;
        dArray[8][15] = 0.729999128;
        dArray[8][16] = 0.459998257;
        dArray[8][17] = 0.08;
        dArray[8][18] = 5.72999477;
        dArray[8][19] = 0.11;
        dArray[9][10] = 2.290005766;
        dArray[9][11] = 0.209999814;
        dArray[9][12] = 4.789996466;
        dArray[9][13] = 0.890000186;
        dArray[9][14] = 0.1;
        dArray[9][15] = 0.4;
        dArray[9][16] = 2.44999163;
        dArray[9][17] = 0.09;
        dArray[9][18] = 0.319999628;
        dArray[9][19] = 9.609996094;
        dArray[10][11] = 0.140000435;
        dArray[10][12] = 3.880005223;
        dArray[10][13] = 2.48000087;
        dArray[10][14] = 1.020000218;
        dArray[10][15] = 0.590000435;
        dArray[10][16] = 0.25;
        dArray[10][17] = 0.520000218;
        dArray[10][18] = 0.240000435;
        dArray[10][19] = 1.799997824;
        dArray[11][12] = 0.65;
        dArray[11][13] = 0.04;
        dArray[11][14] = 0.210000682;
        dArray[11][15] = 0.469999659;
        dArray[11][16] = 1.030000341;
        dArray[11][17] = 0.1;
        dArray[11][18] = 0.08;
        dArray[11][19] = 0.14;
        dArray[12][13] = 0.430000839;
        dArray[12][14] = 0.16;
        dArray[12][15] = 0.29;
        dArray[12][16] = 2.260001679;
        dArray[12][17] = 0.24;
        dArray[12][18] = 0.18;
        dArray[12][19] = 3.230000839;
        dArray[13][14] = 0.17;
        dArray[13][15] = 0.919999502;
        dArray[13][16] = 0.12;
        dArray[13][17] = 0.530000498;
        dArray[13][18] = 5.359991028;
        dArray[13][19] = 0.619999502;
        dArray[14][15] = 2.850002947;
        dArray[14][16] = 1.180000393;
        dArray[14][17] = 0.06;
        dArray[14][18] = 0.1;
        dArray[14][19] = 0.229999411;
        dArray[15][16] = 4.769999273;
        dArray[15][17] = 0.349999273;
        dArray[15][18] = 0.629999273;
        dArray[15][19] = 0.38;
        dArray[16][17] = 0.12;
        dArray[16][18] = 0.209999146;
        dArray[16][19] = 1.12;
        dArray[17][18] = 0.709999299;
        dArray[17][19] = 0.25;
        dArray[18][19] = 0.16;
        this.setEmpiricalRates(dArray, "ARNDCQEGHILKMFPSTWYV");
        double[] dArray2 = new double[n];
        dArray2[0] = 0.076748;
        dArray2[1] = 0.051691;
        dArray2[2] = 0.042645;
        dArray2[3] = 0.051544;
        dArray2[4] = 0.019803;
        dArray2[5] = 0.040752;
        dArray2[6] = 0.06183;
        dArray2[7] = 0.073152;
        dArray2[8] = 0.022944;
        dArray2[9] = 0.053761;
        dArray2[10] = 0.091904;
        dArray2[11] = 0.058676;
        dArray2[12] = 0.023826;
        dArray2[13] = 0.040126;
        dArray2[14] = 0.050901;
        dArray2[15] = 0.068765;
        dArray2[16] = 0.058565;
        dArray2[17] = 0.014261;
        dArray2[18] = 0.032102;
        dArray2[19] = 0.066005;
        this.setEmpiricalFrequencies(dArray2, "ARNDCQEGHILKMFPSTWYV");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "mtDeu amino acid substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

