/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.coalescent.Intervals;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxa;
import dr.evolution.util.TaxonList;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.transmission.TransmissionDemographicModel;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TransmissionSimulator {
    public static final String TRANSMISSION_SIMULATOR = "transmissionSimulator";
    public static final String SOURCE_PATIENT = "sourcePatient";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("sourcePatient", DemographicModel.class, "This describes the demographic process for the source donor patient."), new ElementRule(TransmissionDemographicModel.class, "This describes the demographic process for the recipient patients."), new ElementRule("hostTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)}), new ElementRule("parasiteTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)})};

        @Override
        public String getParserName() {
            return TransmissionSimulator.TRANSMISSION_SIMULATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DemographicModel demographicModel = (DemographicModel)xMLObject.getElementFirstChild(TransmissionSimulator.SOURCE_PATIENT);
            TransmissionDemographicModel transmissionDemographicModel = (TransmissionDemographicModel)xMLObject.getChild(TransmissionDemographicModel.class);
            Tree tree = (Tree)xMLObject.getElementFirstChild("hostTree");
            Tree tree2 = (Tree)xMLObject.getElementFirstChild("parasiteTree");
            Object var6_6 = null;
            return var6_6;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a simulator for a transmission history.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionSimulator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Tree hostTree = null;
    private Tree virusTree = null;
    private int hostCount;
    private Intervals[] intervals;
    private int[] donorHost;
    private double[] transmissionTime;

    public TransmissionSimulator(Taxa taxa, Tree tree, DemographicModel demographicModel) throws TaxonList.MissingTaxonException {
        this(TRANSMISSION_SIMULATOR, taxa, tree, demographicModel);
    }

    public TransmissionSimulator(String string, Taxa taxa, Tree tree, DemographicModel demographicModel) throws TaxonList.MissingTaxonException {
        this.hostTree = tree;
        this.setupHosts();
    }

    private void setupHosts() {
        this.hostCount = this.hostTree.getTaxonCount();
        this.intervals = new Intervals[this.hostCount];
        for (int i = 0; i < this.hostCount; ++i) {
            this.intervals[i] = new Intervals(this.virusTree.getExternalNodeCount() * 3);
        }
        this.donorHost = new int[this.hostCount];
        this.donorHost[0] = -1;
        this.transmissionTime = new double[this.hostCount];
        this.transmissionTime[0] = Double.POSITIVE_INFINITY;
        this.setupHosts(this.hostTree.getRoot());
    }

    private int setupHosts(NodeRef nodeRef) {
        int n;
        if (this.hostTree.isExternal(nodeRef)) {
            n = nodeRef.getNumber();
        } else {
            int n2 = this.setupHosts(this.hostTree.getChild(nodeRef, 0));
            int n3 = this.setupHosts(this.hostTree.getChild(nodeRef, 1));
            this.donorHost[n3] = n2;
            this.transmissionTime[n3] = this.hostTree.getNodeHeight(nodeRef);
            n = n2;
        }
        return n;
    }
}

