/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.LikelihoodTreeTraversal;
import dr.evomodel.treedatalikelihood.ProcessOnTreeDelegate;
import dr.evomodel.treedatalikelihood.RateRescalingScheme;
import dr.inference.model.AbstractModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Profileable;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class TreeDataLikelihood
extends AbstractModelLikelihood
implements TreeTraitProvider,
Citable,
Profileable,
Reportable {
    private static final boolean COUNT_TOTAL_OPERATIONS = true;
    private static final long MAX_UNDERFLOWS_BEFORE_ERROR = 100L;
    private DataLikelihoodDelegate likelihoodDelegate;
    private final Tree treeModel;
    private final BranchRateModel branchRateModel;
    private final TreeTraitProvider.Helper treeTraits = new TreeTraitProvider.Helper();
    private LikelihoodTreeTraversal treeTraversalDelegate;
    private RateRescalingScheme rateRescalingScheme;
    private double logLikelihood;
    private double storedLogLikelihood;
    protected boolean likelihoodKnown;
    private boolean hasInitialized;
    private final boolean isTreeRandom;
    private int totalOperationCount = 0;
    private int totalMatrixUpdateCount = 0;
    private int totalGetLogLikelihoodCount = 0;
    private int totalModelChangedCount = 0;
    private int totalMakeDirtyCount = 0;
    private int totalCalculateLikelihoodCount = 0;
    private int totalRateUpdateAllCount = 0;
    private int totalRateUpdateSingleCount = 0;
    private int totalPostOrderStatistics = 0;
    private int totalCalculatePostOrderStatistics = 0;
    private long totalLikelihoodTime = 0L;

    public TreeDataLikelihood(DataLikelihoodDelegate dataLikelihoodDelegate, Tree tree, BranchRateModel branchRateModel) {
        super("TreeDataLikelihood");
        assert (tree != null);
        assert (branchRateModel != null);
        Logger logger = Logger.getLogger("dr.evomodel");
        logger.info("\nCreating TreeDataLikelihood");
        this.likelihoodDelegate = dataLikelihoodDelegate;
        if (dataLikelihoodDelegate != null) {
            this.addModel(dataLikelihoodDelegate);
            dataLikelihoodDelegate.setCallback(this);
        }
        this.treeModel = tree;
        boolean bl = this.isTreeRandom = tree instanceof AbstractModel && ((AbstractModel)((Object)tree)).isVariable();
        if (this.isTreeRandom) {
            this.addModel((AbstractModel)((Object)tree));
        }
        this.likelihoodKnown = false;
        this.branchRateModel = branchRateModel;
        if (!(branchRateModel instanceof DefaultBranchRateModel)) {
            logger.info("  Branch rate model: " + branchRateModel.getModelName());
        }
        this.addModel(this.branchRateModel);
        this.treeTraversalDelegate = dataLikelihoodDelegate != null ? new LikelihoodTreeTraversal(tree, branchRateModel, dataLikelihoodDelegate.getOptimalTraversalType()) : null;
        this.rateRescalingScheme = dataLikelihoodDelegate != null ? dataLikelihoodDelegate.getRateRescalingScheme() : null;
        this.hasInitialized = dataLikelihoodDelegate != null;
    }

    public final Tree getTree() {
        return this.treeModel;
    }

    public final BranchRateModel getBranchRateModel() {
        return this.branchRateModel;
    }

    public DataLikelihoodDelegate getDataLikelihoodDelegate() {
        return this.likelihoodDelegate;
    }

    public void setDataLikelihoodDelegate(DataLikelihoodDelegate dataLikelihoodDelegate) {
        this.likelihoodDelegate = dataLikelihoodDelegate;
        this.addModel(this.likelihoodDelegate);
        this.likelihoodDelegate.setCallback(this);
        this.treeTraversalDelegate = new LikelihoodTreeTraversal(this.treeModel, this.branchRateModel, this.likelihoodDelegate.getOptimalTraversalType());
        this.rateRescalingScheme = this.likelihoodDelegate.getRateRescalingScheme();
        this.hasInitialized = true;
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (this.likelihoodDelegate != null) {
            ++this.totalGetLogLikelihoodCount;
            if (!this.likelihoodKnown) {
                ++this.totalCalculateLikelihoodCount;
                long l = System.nanoTime();
                this.logLikelihood = this.calculateLogLikelihood();
                long l2 = System.nanoTime();
                this.totalLikelihoodTime += (l2 - l) / 1000000L;
                this.setAllNodesUpdated();
                this.likelihoodKnown = true;
            }
            return this.logLikelihood;
        }
        this.likelihoodKnown = true;
        return 0.0;
    }

    final void calculatePostOrderStatistics() {
        if (this.likelihoodDelegate != null) {
            ++this.totalPostOrderStatistics;
            if (!this.likelihoodKnown) {
                ++this.totalCalculatePostOrderStatistics;
                this.likelihoodDelegate.setComputePostOrderStatisticsOnly(true);
                double d = this.calculateLogLikelihood();
                this.likelihoodDelegate.setComputePostOrderStatisticsOnly(false);
                if (!this.likelihoodDelegate.providesPostOrderStatisticsOnly()) {
                    this.setAllNodesUpdated();
                    this.logLikelihood = d;
                    this.likelihoodKnown = true;
                }
            }
        }
    }

    @Override
    public final void makeDirty() {
        if (this.likelihoodDelegate != null) {
            ++this.totalMakeDirtyCount;
            this.likelihoodKnown = false;
            this.likelihoodDelegate.makeDirty();
            this.updateAllNodes();
        }
    }

    public final boolean isLikelihoodKnown() {
        return this.likelihoodKnown;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        if (this.likelihoodDelegate != null) {
            if (model == this.treeModel) {
                if (object instanceof TreeChangedEvent) {
                    TreeChangedEvent treeChangedEvent = (TreeChangedEvent)object;
                    if (!this.isTreeRandom) {
                        throw new IllegalStateException("Attempting to change a fixed tree");
                    }
                    if (treeChangedEvent.isNodeChanged()) {
                        if (this.rateRescalingScheme == RateRescalingScheme.NONE || this.rateRescalingScheme == RateRescalingScheme.TREE_HEIGHT && !this.treeModel.isRoot(treeChangedEvent.getNode())) {
                            this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                        } else {
                            this.updateAllNodes();
                        }
                    } else if (treeChangedEvent.isTreeChanged()) {
                        this.updateAllNodes();
                    }
                }
            } else if (model == this.likelihoodDelegate) {
                if (object instanceof Parameter) {
                    this.updateAllNodes();
                    this.likelihoodKnown = false;
                } else if (n == -1) {
                    this.updateAllNodes();
                } else {
                    this.updateNode(this.treeModel.getNode(n));
                }
            } else if (model == this.branchRateModel) {
                if (n == -1) {
                    this.updateAllNodes();
                } else {
                    this.updateNode(this.treeModel.getNode(n));
                }
            } else assert (false) : "Unknown componentChangedEvent";
            ++this.totalModelChangedCount;
            this.likelihoodKnown = false;
            this.fireModelChanged();
        }
    }

    @Override
    protected final void storeState() {
        assert (this.likelihoodKnown) : "the likelihood should always be known at this point in the cycle";
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected final void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    private double calculateLogLikelihood() {
        if (this.likelihoodDelegate == null) {
            return 0.0;
        }
        double d = Double.NEGATIVE_INFINITY;
        boolean bl = false;
        long l = 0L;
        do {
            this.treeTraversalDelegate.dispatchTreeTraversalCollectBranchAndNodeOperations();
            List<ProcessOnTreeDelegate.BranchOperation> list = this.treeTraversalDelegate.getBranchOperations();
            List<ProcessOnTreeDelegate.NodeOperation> list2 = this.treeTraversalDelegate.getNodeOperations();
            this.totalMatrixUpdateCount += list.size();
            this.totalOperationCount += list2.size();
            NodeRef nodeRef = this.treeModel.getRoot();
            try {
                d = this.likelihoodDelegate.calculateLikelihood(list, list2, nodeRef.getNumber());
                bl = true;
            }
            catch (DataLikelihoodDelegate.LikelihoodException likelihoodException) {
                this.updateAllNodes();
                ++l;
            }
        } while (!bl && l < 100L);
        return d;
    }

    private void setAllNodesUpdated() {
        this.treeTraversalDelegate.setAllNodesUpdated();
    }

    protected void updateNode(NodeRef nodeRef) {
        ++this.totalRateUpdateSingleCount;
        this.treeTraversalDelegate.updateNode(nodeRef);
        this.likelihoodKnown = false;
    }

    protected void updateNodeAndChildren(NodeRef nodeRef) {
        this.totalRateUpdateSingleCount += 1 + this.treeModel.getChildCount(nodeRef);
        this.treeTraversalDelegate.updateNodeAndChildren(nodeRef);
        this.likelihoodKnown = false;
    }

    protected void updateAllNodes() {
        ++this.totalRateUpdateAllCount;
        this.treeTraversalDelegate.updateAllNodes();
        this.likelihoodKnown = false;
    }

    @Override
    public String getReport() {
        if (this.hasInitialized) {
            StringBuilder stringBuilder = new StringBuilder();
            double d = this.getLogLikelihood();
            String string = this.likelihoodDelegate.getReport();
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append(this.getClass().getName()).append("(").append(d).append(")");
            stringBuilder.append("\n  total operations = ").append(this.totalOperationCount).append("\n  matrix updates = ").append(this.totalMatrixUpdateCount).append("\n  model changes = ").append(this.totalModelChangedCount).append("\n  make dirties = ").append(this.totalMakeDirtyCount).append("\n  calculate likelihoods = ").append(this.totalCalculateLikelihoodCount).append("\n  get likelihoods = ").append(this.totalGetLogLikelihoodCount).append("\n  all rate updates = ").append(this.totalRateUpdateAllCount).append("\n  partial rate updates = ").append(this.totalRateUpdateSingleCount).append("\n  get post-order statistics = ").append(this.totalPostOrderStatistics).append("\n  calculate post-order statistics = ").append(this.totalCalculatePostOrderStatistics).append("\n  average likelihood time = ").append(this.totalLikelihoodTime / (long)this.totalCalculateLikelihoodCount);
            return stringBuilder.toString();
        }
        return this.getClass().getName() + "(uninitialized)";
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.treeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.treeTraits.getTreeTrait(string);
    }

    public void addTrait(TreeTrait treeTrait) {
        this.treeTraits.addTrait(treeTrait);
    }

    public void addTraits(TreeTrait[] treeTraitArray) {
        this.treeTraits.addTraits(treeTraitArray);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.FRAMEWORK;
    }

    @Override
    public String getDescription() {
        if (this.likelihoodDelegate != null && this.likelihoodDelegate instanceof Citable) {
            return ((Citable)((Object)this.likelihoodDelegate)).getDescription();
        }
        return null;
    }

    @Override
    public List<Citation> getCitations() {
        if (this.likelihoodDelegate != null && this.likelihoodDelegate instanceof Citable) {
            return ((Citable)((Object)this.likelihoodDelegate)).getCitations();
        }
        return new ArrayList<Citation>();
    }

    @Override
    public long getTotalCalculationCount() {
        if (this.likelihoodDelegate != null) {
            return this.likelihoodDelegate.getTotalCalculationCount();
        }
        return 0L;
    }
}

