/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.MaskedAlignment;
import dr.evolution.alignment.SiteList;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MaskedAlignmentParser
extends AbstractXMLObjectParser {
    public static final String MASKED_ALIGNMENT = "maskedAlignment";
    public static final String MASK = "mask";
    public static final String NEGATIVE = "negative";
    public static final String INVERSE = "inverse";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("inverse", true), AttributeRule.newBooleanRule("negative", true), new ElementRule(SiteList.class), new ElementRule("mask", String.class, "A parameter of 1s and 0s that represent included and excluded sites")};

    @Override
    public String getParserName() {
        return MASKED_ALIGNMENT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Alignment alignment = (Alignment)xMLObject.getChild(Alignment.class);
        boolean bl = xMLObject.getBooleanAttribute(INVERSE, false) || xMLObject.getBooleanAttribute(NEGATIVE, false);
        String string = (String)xMLObject.getElementFirstChild(MASK);
        boolean[] blArray = new boolean[alignment.getSiteCount()];
        int n = 0;
        int n2 = 0;
        for (char c : string.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            if (n >= blArray.length) break;
            boolean bl2 = c == '0' ? bl : (blArray[n] = !bl);
            if (blArray[n]) {
                ++n2;
            }
            ++n;
        }
        if (n != blArray.length) {
            throw new XMLParseException("The mask needs to be the same length as the alignment (spaces are ignored)");
        }
        if (n2 == 0) {
            throw new XMLParseException("The mask needs to have at least one site unmasked");
        }
        return new MaskedAlignment(alignment, blArray);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }

    @Override
    public String getParserDescription() {
        return "Applies a mask to an alignment so that masked sites are ambiguous.";
    }

    @Override
    public Class getReturnType() {
        return MaskedAlignment.class;
    }
}

